package ungp.scripts.campaign.specialist.skills;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FleetDataAPI;
import com.fs.starfarer.api.characters.CharacterStatsSkillEffect;
import com.fs.starfarer.api.characters.FleetTotalItem;
import com.fs.starfarer.api.characters.FleetTotalSource;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.characters.ShipSkillEffect;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI.HullSize;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.skills.BaseSkillEffectDescription;
import java.util.Iterator;
import ungp.api.rules.tags.UNGP_PlayerCharacterStatsSkillTag;
import ungp.api.rules.tags.UNGP_PlayerShipSkillTag;
import ungp.scripts.campaign.specialist.rules.UNGP_RulesManager;
import ungp.scripts.campaign.specialist.rules.UNGP_RulesManager.URule;

public class UNGP_SpecialistSkills {


   public static class UNGP_SpecialistCharacterSkill extends BaseSkillEffectDescription implements CharacterStatsSkillEffect, FleetTotalSource {

      public void apply(MutableCharacterStatsAPI stats, String id, float level) {
         Iterator var4 = UNGP_RulesManager.PLAYER_CHARACTER_SKILL_TAGS_ITG.iterator();

         while(var4.hasNext()) {
            UNGP_PlayerCharacterStatsSkillTag tag = (UNGP_PlayerCharacterStatsSkillTag)var4.next();
            tag.apply(stats);
         }

      }

      public void unapply(MutableCharacterStatsAPI stats, String id) {
         Iterator var3 = UNGP_RulesManager.getAllRulesCopy().iterator();

         while(var3.hasNext()) {
            URule rule = (URule)var3.next();
            if(rule.getRuleEffect() instanceof UNGP_PlayerCharacterStatsSkillTag) {
               ((UNGP_PlayerCharacterStatsSkillTag)rule.getRuleEffect()).unapply(stats);
            }
         }

      }

      public FleetTotalItem getFleetTotalItem() {
         return this.getOPTotal();
      }
   }

   public static class UNGP_SpecialistShipSkill extends BaseSkillEffectDescription implements ShipSkillEffect, FleetTotalSource {

      public void apply(MutableShipStatsAPI stats, HullSize hullSize, String id, float level) {
         FleetDataAPI fleetData = null;
         FleetMemberAPI member = stats.getFleetMember();
         if(isInCampaign()) {
            fleetData = Global.getSector().getPlayerFleet().getFleetData();
         } else if(member != null) {
            fleetData = member.getFleetDataForStats();
            if(fleetData == null) {
               fleetData = member.getFleetData();
            }
         }

         Iterator var7 = UNGP_RulesManager.PLAYER_SHIP_SKILL_TAGS_ITG.iterator();

         while(var7.hasNext()) {
            UNGP_PlayerShipSkillTag tag = (UNGP_PlayerShipSkillTag)var7.next();
            tag.apply(fleetData, member, stats, hullSize);
         }

      }

      public void unapply(MutableShipStatsAPI stats, HullSize hullSize, String id) {
         Iterator var4 = UNGP_RulesManager.getAllRulesCopy().iterator();

         while(var4.hasNext()) {
            URule rule = (URule)var4.next();
            if(rule.getRuleEffect() instanceof UNGP_PlayerShipSkillTag) {
               ((UNGP_PlayerShipSkillTag)rule.getRuleEffect()).unapply(stats, hullSize);
            }
         }

      }

      public FleetTotalItem getFleetTotalItem() {
         return this.getOPTotal();
      }
   }
}
