package ungp.scripts.campaign.specialist.rules;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.ui.UIComponentAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI.TooltipCreator;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import javax.net.ssl.HttpsURLConnection;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;
import ungp.api.rules.UNGP_RuleEffectAPI;
import ungp.api.rules.tags.UNGP_CampaignListenerTag;
import ungp.api.rules.tags.UNGP_CampaignTag;
import ungp.api.rules.tags.UNGP_CombatInitTag;
import ungp.api.rules.tags.UNGP_CombatTag;
import ungp.api.rules.tags.UNGP_EconomyTag;
import ungp.api.rules.tags.UNGP_PlayerCharacterStatsSkillTag;
import ungp.api.rules.tags.UNGP_PlayerFleetMemberTag;
import ungp.api.rules.tags.UNGP_PlayerFleetTag;
import ungp.api.rules.tags.UNGP_PlayerShipSkillTag;
import ungp.api.rules.tags.UNGP_TweakBeforeApplyTag;
import ungp.scripts.campaign.UNGP_InGameData;
import ungp.scripts.campaign.specialist.UNGP_SpecialistManager;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings.Difficulty;
import ungp.scripts.campaign.specialist.challenges.UNGP_ChallengeInfo;
import ungp.scripts.campaign.specialist.challenges.UNGP_ChallengeManager;
import ungp.scripts.campaign.specialist.challenges.UNGP_ChallengeProgress;
import ungp.scripts.campaign.specialist.economy.UNGP_EconomyListener;
import ungp.scripts.campaign.specialist.rules.UNGP_RuleInfoLoader;
import ungp.scripts.ui.RuleDescBackgroundPlugin;
import ungp.scripts.utils.Constants;
import ungp.scripts.utils.UNGPUtils;
import ungp.scripts.utils.UNGP_Feedback;

public class UNGP_RulesManager {

   private static final Color POSITIVE_COLOR = new Color(50, 255, 50);
   private static final Color NEGATIVE_COLOR = new Color(255, 50, 50);
   private static final Color GOLDEN_COLOR = new Color(255, 215, 0);
   private static final Color MILESTONE_COLOR = new Color(158, 41, 255);
   private static final Logger LOGGER = Global.getLogger(UNGP_RulesManager.class);
   private static List ALL_RULES = new ArrayList();
   public static List ACTIVATED_RULES_IN_THIS_GAME = new ArrayList();
   public static List COMBAT_RULES_IN_THIS_GAME = new ArrayList();
   public static List CAMPAIGN_RULES_IN_THIS_GAME = new ArrayList();
   public static List ECONOMY_TAGS_ITG = new ArrayList();
   public static List CAMPAIGN_TAGS_ITG = new ArrayList();
   public static List PLAYER_FLEET_TAGS_ITG = new ArrayList();
   public static List PLAYER_FLEET_MEMBER_TAGS_ITG = new ArrayList();
   public static List PLAYER_SHIP_SKILL_TAGS_ITG = new ArrayList();
   public static List PLAYER_CHARACTER_SKILL_TAGS_ITG = new ArrayList();
   private static boolean needUpdateCache = false;
   private static boolean isSpecialistMode = false;
   private static Difficulty globalDifficulty = null;


   public static void initOrReloadRules() {
      loadAllRules(UNGP_RuleInfoLoader.loadAllRuleInformation());
   }

   public static void tagAllChallengeProviders() {
      List challengesCopy = UNGP_ChallengeManager.getChallengeInfosCopy();
      Iterator var1 = challengesCopy.iterator();

      while(var1.hasNext()) {
         UNGP_ChallengeInfo challengeInfo = (UNGP_ChallengeInfo)var1.next();

         UNGP_RulesManager.URule rule;
         for(Iterator var3 = challengeInfo.getRulesRequired().iterator(); var3.hasNext(); rule.isMilestoneProvider = true) {
            rule = (UNGP_RulesManager.URule)var3.next();
         }
      }

   }

   public static void updateCacheNextFrame() {
      needUpdateCache = true;
   }

   public static boolean isCacheNeedUpdate() {
      return needUpdateCache;
   }

   public static void updateRulesCache() {
      UNGP_InGameData inGameData = UNGP_InGameData.getDataInSave();
      if(inGameData != null) {
         LOGGER.info("Start updating rule caches...");
         ACTIVATED_RULES_IN_THIS_GAME.clear();
         COMBAT_RULES_IN_THIS_GAME.clear();
         CAMPAIGN_RULES_IN_THIS_GAME.clear();
         CAMPAIGN_TAGS_ITG.clear();
         ECONOMY_TAGS_ITG.clear();
         PLAYER_FLEET_TAGS_ITG.clear();
         PLAYER_FLEET_MEMBER_TAGS_ITG.clear();
         PLAYER_SHIP_SKILL_TAGS_ITG.clear();
         PLAYER_CHARACTER_SKILL_TAGS_ITG.clear();
         List activatedRules = inGameData.getActivatedRules();
         CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
         MutableCharacterStatsAPI playerStats = Global.getSector().getPlayerStats();
         Iterator beforeApplyTags = ALL_RULES.iterator();

         while(beforeApplyTags.hasNext()) {
            UNGP_RulesManager.URule originalActivatedRules = (UNGP_RulesManager.URule)beforeApplyTags.next();
            originalActivatedRules.isMilestoneRollLocked = true;
            UNGP_RuleEffectAPI activatedRulesSet = originalActivatedRules.getRuleEffect();
            activatedRulesSet.unapplyGlobalStats();
            if(activatedRulesSet instanceof UNGP_CampaignListenerTag) {
               Class difficulty = ((UNGP_CampaignListenerTag)activatedRulesSet).getClassOfListener();
               Global.getSector().getListenerManager().removeListenerOfClass(difficulty);
            }

            if(activatedRulesSet instanceof UNGP_PlayerFleetTag && playerFleet != null) {
               ((UNGP_PlayerFleetTag)activatedRulesSet).unapplyPlayerFleetStats(playerFleet);
            }

            if(activatedRulesSet instanceof UNGP_EconomyTag) {
               UNGP_EconomyListener.unapplyMarkets((UNGP_EconomyTag)activatedRulesSet);
            }
         }

         ArrayList beforeApplyTags1 = new ArrayList();
         Iterator originalActivatedRules1 = activatedRules.iterator();

         while(originalActivatedRules1.hasNext()) {
            UNGP_RulesManager.URule activatedRulesSet1 = (UNGP_RulesManager.URule)originalActivatedRules1.next();
            UNGP_RuleEffectAPI difficulty1 = activatedRulesSet1.getRuleEffect();
            if(difficulty1 instanceof UNGP_TweakBeforeApplyTag) {
               beforeApplyTags1.add((UNGP_TweakBeforeApplyTag)difficulty1);
            }
         }

         List originalActivatedRules2 = List.copyOf(activatedRules);
         Iterator activatedRulesSet2 = beforeApplyTags1.iterator();

         while(activatedRulesSet2.hasNext()) {
            UNGP_TweakBeforeApplyTag difficulty2 = (UNGP_TweakBeforeApplyTag)activatedRulesSet2.next();
            difficulty2.tweakBeforeApply(activatedRules, originalActivatedRules2);
         }

         updateRollableMilestoneRules(inGameData);
         HashSet activatedRulesSet3 = new HashSet(activatedRules);
         activatedRules.clear();
         activatedRules.addAll(activatedRulesSet3);
         Difficulty difficulty3 = inGameData.getDifficulty();
         Iterator var8 = activatedRules.iterator();

         while(var8.hasNext()) {
            UNGP_RulesManager.URule rule = (UNGP_RulesManager.URule)var8.next();
            ACTIVATED_RULES_IN_THIS_GAME.add(rule);
            UNGP_RuleEffectAPI effect = rule.getRuleEffect();
            effect.updateDifficultyCache(difficulty3);
            effect.applyGlobalStats();
            if(effect instanceof UNGP_CampaignListenerTag) {
               Global.getSector().getListenerManager().addListener(((UNGP_CampaignListenerTag)effect).getListener(), true);
            }

            if(!(effect instanceof UNGP_CombatTag) && !(effect instanceof UNGP_CombatInitTag)) {
               CAMPAIGN_RULES_IN_THIS_GAME.add(rule);
            } else {
               COMBAT_RULES_IN_THIS_GAME.add(rule);
            }

            if(effect instanceof UNGP_PlayerFleetTag && playerFleet != null) {
               ((UNGP_PlayerFleetTag)effect).applyPlayerFleetStats(playerFleet);
               PLAYER_FLEET_TAGS_ITG.add((UNGP_PlayerFleetTag)effect);
            }

            if(effect instanceof UNGP_PlayerFleetMemberTag) {
               PLAYER_FLEET_MEMBER_TAGS_ITG.add((UNGP_PlayerFleetMemberTag)effect);
            }

            if(effect instanceof UNGP_EconomyTag) {
               ECONOMY_TAGS_ITG.add((UNGP_EconomyTag)effect);
            }

            if(effect instanceof UNGP_CampaignTag) {
               CAMPAIGN_TAGS_ITG.add((UNGP_CampaignTag)effect);
            }

            if(effect instanceof UNGP_PlayerShipSkillTag) {
               PLAYER_SHIP_SKILL_TAGS_ITG.add((UNGP_PlayerShipSkillTag)effect);
            }

            if(effect instanceof UNGP_PlayerCharacterStatsSkillTag) {
               PLAYER_CHARACTER_SKILL_TAGS_ITG.add((UNGP_PlayerCharacterStatsSkillTag)effect);
            }
         }

         if(!ECONOMY_TAGS_ITG.isEmpty()) {
            UNGP_EconomyListener.addListener();
            UNGP_EconomyListener.applyMarkets();
         }

         setStaticDifficulty(difficulty3);
         inGameData.saveActivatedRules(activatedRules);
         UNGP_SpecialistManager.updateCachedSpecialistMode(inGameData.isHardMode());
         UNGP_ChallengeManager.updateChallengeProgress(inGameData);
         updateSpecialistSkills(playerStats);
         if(playerFleet != null) {
            playerFleet.forceSync();
         }

         LOGGER.info("Rule caches update completed.");
      }

      needUpdateCache = false;
   }

   private static void updateSpecialistSkills(MutableCharacterStatsAPI stats) {
      if(stats != null) {
         if(PLAYER_SHIP_SKILL_TAGS_ITG.isEmpty()) {
            stats.setSkillLevel("UNGP_specialist_player_ship_skill", 0.0F);
         } else {
            stats.setSkillLevel("UNGP_specialist_player_ship_skill", 1.0F);
         }

         if(PLAYER_CHARACTER_SKILL_TAGS_ITG.isEmpty()) {
            stats.setSkillLevel("UNGP_specialist_player_character_skill", 0.0F);
         } else {
            stats.setSkillLevel("UNGP_specialist_player_character_skill", 1.0F);
         }

         stats.refreshCharacterStatsEffects();
      }
   }

   public static Difficulty getGlobalDifficulty() {
      return globalDifficulty;
   }

   public static List getAllRulesCopy() {
      return new ArrayList(ALL_RULES);
   }

   public static void updateRollableMilestoneRules(UNGP_InGameData dataInSave) {
      Iterator var1 = dataInSave.getCompletedChallenges().iterator();

      while(var1.hasNext()) {
         String completedChallenge = (String)var1.next();
         UNGP_ChallengeInfo info = UNGP_ChallengeManager.getChallengeInfo(completedChallenge);
         if(info != null) {
            UNGP_RulesManager.URule rule = info.getMilestoneToUnlock();
            if(rule != null) {
               rule.isMilestoneRollLocked = false;
            }
         }
      }

   }

   public static void addRuleItemTooltip(TooltipMakerAPI tooltip, UNGP_RulesManager.URule rule, boolean isExpanded) {
      rule.addDetailsToTooltip(tooltip, isExpanded, false);
   }

   public static TooltipCreator createRuleItemTooltip(final UNGP_RulesManager.URule rule) {
      return new TooltipCreator() {
         public boolean isTooltipExpandable(Object tooltipParam) {
            return rule.isTooltipExpandable();
         }
         public float getTooltipWidth(Object tooltipParam) {
            return UNGP_RulesManager.getCommonWidth();
         }
         public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
            UNGP_RulesManager.addRuleItemTooltip(tooltip, rule, expanded);
         }
      };
   }

   public static float getCommonWidth() {
      return 400.0F;
   }

   public static String getRuleTypeName(boolean isMilestone, boolean isGolden, boolean isPositive) {
      StringBuilder sb = new StringBuilder();
      if(isMilestone) {
         if(isGolden) {
            sb.append(Constants.rules_i18n.get("prefix_golden"));
            sb.append(Constants.rules_i18n.get("middle_space"));
         }

         sb.append(Constants.rules_i18n.get("prefix_milestone"));
      } else if(isGolden) {
         sb.append(Constants.rules_i18n.get("prefix_golden"));
      } else if(isPositive) {
         sb.append(Constants.rules_i18n.get("prefix_positive"));
      } else {
         sb.append(Constants.rules_i18n.get("prefix_negative"));
      }

      sb.append(Constants.rules_i18n.get("middle_space"));
      sb.append(Constants.rules_i18n.get("suffix_rule"));
      return sb.toString();
   }

   private static void loadAllRules(List ruleInfos) {
      ALL_RULES.clear();
      Iterator var1 = ruleInfos.iterator();

      while(var1.hasNext()) {
         UNGP_RuleInfoLoader.UNGP_RuleInfo info = (UNGP_RuleInfoLoader.UNGP_RuleInfo)var1.next();
         ALL_RULES.add(new UNGP_RulesManager.URule(info));
      }

      loadPickTimes();
   }

   public static void loadPickTimes() {
      Thread thread = new Thread(new Runnable() {
         public void run() {
            String url = Constants.rules_i18n.get("pick_times_collection_url");

            try {
               URL e = new URL(url);
               HttpsURLConnection conn = (HttpsURLConnection)e.openConnection();
               UNGP_Feedback.setHttpProtocol(conn);
               InputStream stream = conn.getInputStream();
               Scanner scanner = (new Scanner(stream, "utf-8")).useDelimiter("\\A");
               if(scanner.hasNext()) {
                  String collectionText = scanner.next();

                  try {
                     JSONObject e1 = new JSONObject(collectionText);
                     Iterator var8 = UNGP_RulesManager.ALL_RULES.iterator();

                     while(var8.hasNext()) {
                        UNGP_RulesManager.URule rule = (UNGP_RulesManager.URule)var8.next();
                        rule.setPickedTimes(e1.optInt(rule.getId(), -1));
                     }

                     UNGP_RulesManager.LOGGER.info("Successfully loaded the pick times of rules from deep sync...");
                  } catch (JSONException var10) {
                     UNGP_RulesManager.LOGGER.warn("Error loading json...");
                  }
               }

               stream.close();
            } catch (IOException var11) {
               UNGP_RulesManager.LOGGER.warn(var11);
            }

         }
      });
      thread.setDaemon(true);
      thread.start();
   }

   public static String getPNRuleString(boolean isPositive) {
      return getRuleTypeName(false, false, isPositive);
   }

   public static String getGoldenRuleString() {
      return getRuleTypeName(false, true, true);
   }

   public static String getRuleIconSpriteName(boolean isMilestone, boolean isGolden, boolean isPositive) {
      StringBuilder sb = new StringBuilder("graphics/ungp/icons/");
      if(isMilestone) {
         if(isGolden) {
            sb.append("golden");
            sb.append("_");
         }

         sb.append("milestone");
      } else if(isGolden) {
         sb.append("golden");
      } else {
         sb.append(isPositive?"positive":"negative");
      }

      sb.append("_icon.png");
      return sb.toString();
   }

   public static Color getPNColor(boolean isPositive) {
      return isPositive?POSITIVE_COLOR:NEGATIVE_COLOR;
   }

   public static Color getGoldenColor() {
      return GOLDEN_COLOR;
   }

   public static Color getMilestoneColor() {
      return MILESTONE_COLOR;
   }

   public static Color getHighlightColor(boolean isPositive) {
      return isPositive?Misc.getPositiveHighlightColor():Misc.getNegativeHighlightColor();
   }

   public static void setStaticDifficulty(Difficulty difficulty) {
      globalDifficulty = difficulty;
   }

   public static List getAvailableRules(List completedChallenges) {
      ArrayList unlockedRuleIds = new ArrayList();
      Iterator availableRules = completedChallenges.iterator();

      while(availableRules.hasNext()) {
         String completedChallenge = (String)availableRules.next();
         UNGP_ChallengeInfo rule = UNGP_ChallengeManager.getChallengeInfo(completedChallenge);
         if(rule != null) {
            String mileStoneRuleId = rule.getMilestoneToUnlock().getId();
            if(!mileStoneRuleId.isEmpty()) {
               unlockedRuleIds.add(mileStoneRuleId);
            }
         }
      }

      ArrayList availableRules1 = new ArrayList();
      Iterator completedChallenge1 = ALL_RULES.iterator();

      while(completedChallenge1.hasNext()) {
         UNGP_RulesManager.URule rule1 = (UNGP_RulesManager.URule)completedChallenge1.next();
         if(rule1.isMilestone()) {
            if(unlockedRuleIds.contains(rule1.getId())) {
               availableRules1.add(rule1);
            }
         } else {
            availableRules1.add(rule1);
         }
      }

      return availableRules1;
   }


   public static final class URule {

      private String buffID;
      private UNGP_RuleInfoLoader.UNGP_RuleInfo ruleInfo;
      private boolean isMilestoneRollLocked = true;
      private boolean isMilestoneProvider = false;
      private boolean isDescAffectedByLevel;
      private int pickedTimes = -1;


      public void setPickedTimes(int pickedTimes) {
         this.pickedTimes = pickedTimes;
      }

      public int getPickedTimes() {
         return this.pickedTimes;
      }

      URule(UNGP_RuleInfoLoader.UNGP_RuleInfo info) {
         this.buffID = info.getId();
         this.ruleInfo = info;
         this.ruleInfo.getEffectPlugin().setRule(this);
         this.isDescAffectedByLevel = this.isDescAffectedByLevel();
      }

      public String getId() {
         return this.ruleInfo.getId();
      }

      public String getCodexEntryId() {
         return this.getId();
      }

      /** @deprecated */
      @Deprecated
      public String getBuffID() {
         return this.buffID;
      }

      public String getName() {
         return this.ruleInfo.getName();
      }

      public String getSpritePath() {
         return this.ruleInfo.getSpritePath();
      }

      public boolean isDefaultSource() {
         return UNGPUtils.isEmpty(this.ruleInfo.getSource());
      }

      /** @deprecated */
      @Deprecated
      public boolean isBonus() {
         return this.ruleInfo.isBonus();
      }

      public boolean isPositive() {
         return this.ruleInfo.isBonus();
      }

      public boolean isGolden() {
         return this.ruleInfo.isGolden();
      }

      public Color getCorrectColor() {
         return this.isMilestone()?(this.isGolden()?UNGP_RulesManager.GOLDEN_COLOR:UNGP_RulesManager.MILESTONE_COLOR):(this.isGolden()?UNGP_RulesManager.GOLDEN_COLOR:UNGP_RulesManager.getPNColor(this.isPositive()));
      }

      public Color getTooltipTitleColor() {
         return Misc.interpolateColor(this.getCorrectColor(), Misc.getTextColor(), 0.8F);
      }

      public Color getCostColor() {
         return this.getCost() >= 0?Misc.getHighlightColor():Misc.getNegativeHighlightColor();
      }

      public String getRuleTypeName() {
         return UNGP_RulesManager.getRuleTypeName(this.isMilestone(), this.isGolden(), this.isPositive());
      }

      public String getRuleTypeCharacter() {
         return this.isGolden()?"G":(this.isMilestone()?"M":(this.isPositive()?"P":"N"));
      }

      public void addPreDesc(TooltipMakerAPI tooltip, float pad) {
         TooltipMakerAPI image = tooltip.beginImageWithText(UNGP_RulesManager.getRuleIconSpriteName(this.isMilestone(), this.isGolden(), this.isPositive()), 16.0F);
         image.addPara(this.getRuleTypeName(), this.getCorrectColor(), 0.0F);
         tooltip.addImageWithText(pad * 0.5F);
         if(!this.isDefaultSource()) {
            tooltip.setParaFontVictor14();
            Constants.rules_i18n.get("rule_source").addPara(this.ruleInfo.getSource(), Misc.getGrayColor(), pad * 0.5F);
            tooltip.setParaFontDefault();
         }

      }

      public void addDesc(TooltipMakerAPI tooltip, float pad, String prefix, Difficulty difficulty) {
         String[] values;
         if(difficulty == null) {
            values = this.getDescriptionParams(Difficulty.GAMMA);
         } else {
            values = this.getDescriptionParams(difficulty);
         }

         Color highlightColor = this.isPositive()?Misc.getHighlightColor():Misc.getNegativeHighlightColor();
         prefix.addPara(this.ruleInfo.getDesc(), pad, highlightColor, values);
      }

      public void addDesc(TooltipMakerAPI tooltip, float pad, String prefix) {
         this.addDesc(tooltip, pad, prefix, UNGP_RulesManager.globalDifficulty);
      }

      public void addDescToItem(TooltipMakerAPI tooltip, float pad, String prefix, boolean isExpanded) {
         if(!this.isDescAffectedByLevel) {
            tooltip.addPara(Constants.rules_i18n.get("front_desc"), pad * 0.5F, Misc.getBasePlayerColor(), Misc.getHighlightColor(), new String[]{Constants.rules_i18n.get("any")});
            this.addDesc(tooltip, pad, prefix, (Difficulty)null);
         } else {
            Difficulty difficulty = UNGP_RulesManager.globalDifficulty;
            if(isExpanded) {
               Difficulty[] var6 = Difficulty.values();
               int var7 = var6.length;

               for(int var8 = 0; var8 < var7; ++var8) {
                  Difficulty itemDifficulty = var6[var8];
                  tooltip.addPara(Constants.rules_i18n.get("front_desc"), pad * 0.5F, difficulty == itemDifficulty?Misc.getGrayColor():Misc.getBasePlayerColor(), itemDifficulty.color, new String[]{itemDifficulty.name});
                  this.addDesc(tooltip, pad, prefix, itemDifficulty);
                  tooltip.addSpacer(pad * 0.5F);
               }
            } else {
               tooltip.addPara(Constants.rules_i18n.get("front_desc"), pad * 0.5F, Misc.getBasePlayerColor(), difficulty.color, new String[]{difficulty.name});
               this.addDesc(tooltip, pad, prefix, difficulty);
            }
         }

      }

      public String[] getDescriptionParams(Difficulty difficulty) {
         String[] values = new String[10];

         for(int i = 0; i < 10; ++i) {
            values[i] = this.getRuleEffect().getDescriptionParams(i, difficulty);
         }

         return values;
      }

      public boolean isDescAffectedByLevel() {
         String lastCompared = null;
         Difficulty[] var2 = Difficulty.values();
         int var3 = var2.length;

         for(int var4 = 0; var4 < var3; ++var4) {
            Difficulty difficulty = var2[var4];
            String[] values = this.getDescriptionParams(difficulty);
            StringBuilder sb = new StringBuilder();
            String[] compared = values;
            int var9 = values.length;

            for(int var10 = 0; var10 < var9; ++var10) {
               String value = compared[var10];
               sb.append(value);
            }

            if(lastCompared == null) {
               lastCompared = sb.toString();
            } else {
               String var12 = sb.toString();
               if(!lastCompared.contentEquals(var12)) {
                  return true;
               }
            }
         }

         return false;
      }

      public void addRollDesc(TooltipMakerAPI tooltip, float pad, String prefix) {
         if(!this.isBasicallyRollable()) {
            prefix.addPara(Constants.rules_i18n.get("not_rollable"), Misc.getGrayColor(), pad);
         }

      }

      public void addChallengeRelatedDesc(TooltipMakerAPI tooltip, float pad, String prefix, boolean isExpanded, boolean isCodex) {
         Color grayColor = Misc.getGrayColor();
         List challengesCopy;
         ArrayList provider;
         Iterator hasUncompletedChallenges;
         UNGP_ChallengeInfo difficultyEnough;
         if(this.isMilestone()) {
            challengesCopy = UNGP_ChallengeManager.getChallengeInfosCopy();
            provider = new ArrayList();
            hasUncompletedChallenges = challengesCopy.iterator();

            while(hasUncompletedChallenges.hasNext()) {
               difficultyEnough = (UNGP_ChallengeInfo)hasUncompletedChallenges.next();
               if(difficultyEnough.getMilestoneToUnlock().equals(this)) {
                  provider.add(difficultyEnough);
               }
            }

            if(!provider.isEmpty()) {
               tooltip.addPara(Constants.rules_i18n.get("milestone_tip"), Misc.getBasePlayerColor(), pad);
               tooltip.addSpacer(10.0F);
               tooltip.setBulletedListMode(prefix);
               hasUncompletedChallenges = provider.iterator();

               while(hasUncompletedChallenges.hasNext()) {
                  difficultyEnough = (UNGP_ChallengeInfo)hasUncompletedChallenges.next();
                  difficultyEnough.getName();
                  String sb = difficultyEnough.getConnectedRuleNames();
                  tooltip.addPara(sb, grayColor, 5.0F);
               }
            }
         } else {
            challengesCopy = UNGP_ChallengeManager.getChallengeInfosCopy();
            provider = new ArrayList();
            hasUncompletedChallenges = challengesCopy.iterator();

            while(hasUncompletedChallenges.hasNext()) {
               difficultyEnough = (UNGP_ChallengeInfo)hasUncompletedChallenges.next();
               if(difficultyEnough.getRulesRequired().contains(this)) {
                  provider.add(difficultyEnough);
               }
            }

            if(!provider.isEmpty()) {
               boolean hasUncompletedChallenges1 = false;
               boolean difficultyEnough1 = UNGP_ChallengeManager.isDifficultyEnough(UNGP_RulesManager.globalDifficulty);
               tooltip.addPara(Constants.rules_i18n.get("challenge_tip"), Misc.getBasePlayerColor(), pad);
               tooltip.addSpacer(10.0F);
               Iterator sb1 = provider.iterator();

               while(sb1.hasNext()) {
                  UNGP_ChallengeInfo challengeInfo = (UNGP_ChallengeInfo)sb1.next();
                  tooltip.setBulletedListMode(prefix);
                  boolean isChallengeCompleted = !UNGP_ChallengeManager.getTemporaryCompletedChallenges().isEmpty() && UNGP_ChallengeManager.getTemporaryCompletedChallenges().contains(challengeInfo.getId());
                  tooltip.addSpacer(5.0F);
                  if(isCodex) {
                     tooltip.addPara(challengeInfo.getName(), UNGP_RulesManager.MILESTONE_COLOR, 0.0F);
                  } else if(isChallengeCompleted) {
                     challengeInfo.getName().addPara(Constants.rules_i18n.get("challenge_tip_completed"), grayColor, 0.0F);
                  } else {
                     tooltip.addPara(challengeInfo.getName(), 0.0F, UNGP_RulesManager.MILESTONE_COLOR, Misc.getNegativeHighlightColor(), new String[]{Constants.rules_i18n.get("challenge_tip_uncompleted")});
                     hasUncompletedChallenges1 = true;
                  }

                  if(isExpanded) {
                     tooltip.setBulletedListMode(prefix);
                     challengeInfo.showChallengeDetails(tooltip, grayColor, (UNGP_ChallengeProgress)null);
                  }
               }

               if(hasUncompletedChallenges1 && !difficultyEnough1 && !isCodex) {
                  tooltip.setBulletedListMode(prefix);
                  tooltip.addPara(Constants.rules_i18n.get("challenge_tip_difficultyNotMeet"), 5.0F, Misc.getNegativeHighlightColor(), grayColor, new String[]{Difficulty.ALPHA.name, Difficulty.OMEGA.name}).setHighlightColors(new Color[]{Difficulty.ALPHA.color, Difficulty.OMEGA.color});
               }
            }
         }

         tooltip.setBulletedListMode((String)null);
      }

      public void addChallengeRelatedDesc(TooltipMakerAPI tooltip, float pad, String detailPrefix, boolean showMore) {
         this.addChallengeRelatedDesc(tooltip, pad, detailPrefix, showMore, false);
      }

      public void addDetailsToTooltip(TooltipMakerAPI tooltip, boolean isExpanded, boolean isCodex) {
         float pad = 18.0F;
         String bulletPrefix = "        ";
         RuleDescBackgroundPlugin.addToTooltip(tooltip, this, isCodex);
         tooltip.setTitleOrbitronLarge();
         tooltip.addTitle(this.getName(), this.getTooltipTitleColor());
         this.addPreDesc(tooltip, pad);
         this.addDescToItem(tooltip, pad, bulletPrefix, isExpanded);
         this.addRollDesc(tooltip, pad, bulletPrefix);
         this.addChallengeRelatedDesc(tooltip, pad, bulletPrefix, isExpanded, isCodex);
         this.addCostAndPickTimes(tooltip, pad);
         if(!isCodex) {
            tooltip.setCodexEntryId(this.getId());
         }

      }

      public boolean isTooltipExpandable() {
         return this.isMilestoneProvider || this.isDescAffectedByLevel;
      }

      public void addDesc(TooltipMakerAPI tooltip, float pad) {
         this.addDesc(tooltip, pad, "");
      }

      public void addShortDesc(TooltipMakerAPI tooltip, float pad) {
         tooltip.addPara(this.ruleInfo.getShortDesc(), pad);
      }

      public Object[] generateCombatTips(Difficulty difficulty) {
         ArrayList messageList = new ArrayList();
         String originDesc = this.ruleInfo.getDesc();
         String[] unformulatedDesc = originDesc.split("%s");
         Color baseColor = UNGP_RulesManager.getPNColor(this.isPositive());
         Color hlColor = this.isPositive()?Misc.getHighlightColor():Misc.getNegativeHighlightColor();

         for(int i = 0; i < unformulatedDesc.length; ++i) {
            String baseString = unformulatedDesc[i];
            if(baseString != null && !baseString.isEmpty()) {
               messageList.add(baseColor);
               messageList.add(baseString);
            }

            String hlString = this.getRuleEffect().getDescriptionParams(i, difficulty);
            if(hlString != null && !hlString.isEmpty()) {
               messageList.add(hlColor);
               messageList.add(this.getRuleEffect().getDescriptionParams(i, difficulty));
            }
         }

         return messageList.toArray();
      }

      public void addCostAndPickTimes(TooltipMakerAPI tooltip, float pad) {
         UIComponentAPI spacer = tooltip.addSpacer(this.pickedTimes > 0?pad - 12.0F:pad);
         LabelAPI para = null;
         if(this.pickedTimes > 0) {
            tooltip.setParaFontVictor14();
            para = tooltip.addPara(Constants.rules_i18n.get("pick_times_desc"), 0.0F, Misc.getGrayColor(), Misc.getStoryOptionColor(), new String[]{Constants.rules_i18n.get("button_feedback"), this.pickedTimes});
            para.setAlignment(Alignment.RMID);
            para.setOpacity(0.8F);
            para.getPosition().inBR(0.0F, 5.0F);
            tooltip.setParaFontDefault();
         }

         Object cost = this.getCost();
         Color baseColor = Misc.getBasePlayerColor();
         Object costString;
         Color highlight;
         if(cost > 0) {
            highlight = UNGP_RulesManager.getHighlightColor(true);
            costString = cost;
         } else if(cost == 0) {
            highlight = Misc.getHighlightColor();
            costString = cost;
         } else {
            highlight = UNGP_RulesManager.getHighlightColor(false);
            costString = cost;
         }

         tooltip.setParaOrbitronLarge();
         LabelAPI costLabel = tooltip.addPara(Constants.rules_i18n.get("cost_point"), 0.0F, baseColor, highlight, new String[]{(String)costString});
         if(para != null) {
            costLabel.getPosition().belowLeft(spacer, costLabel.getPosition().getHeight() - 8.0F);
         }

         tooltip.setParaFontDefault();
      }

      public int getCost() {
         return this.ruleInfo.getCost();
      }

      public String getCostString() {
         // $FF: Couldn't be decompiled
      }

      public UNGP_RuleEffectAPI getRuleEffect() {
         return this.ruleInfo.getEffectPlugin();
      }

      public UNGP_RuleInfoLoader.UNGP_RuleInfo getRuleInfo() {
         return this.ruleInfo;
      }

      public String getExtra1() {
         return this.ruleInfo.getExtra1();
      }

      public String getExtra2() {
         return this.ruleInfo.getExtra2();
      }

      public boolean hasTag(String tag) {
         return this.ruleInfo.getTags().contains(tag);
      }

      public boolean hasTag(UNGP_RulesManager.URule.Tags tag) {
         return this.ruleInfo.getTags().contains(tag.id);
      }

      public static UNGP_RulesManager.URule getByID(String id) {
         Iterator var1 = UNGP_RulesManager.ALL_RULES.iterator();

         UNGP_RulesManager.URule rule;
         do {
            if(!var1.hasNext()) {
               return null;
            }

            rule = (UNGP_RulesManager.URule)var1.next();
         } while(!rule.getId().contentEquals(id));

         return rule;
      }

      public boolean isRollable() {
         return !this.isBasicallyRollable()?false:(this.isMilestone()?!this.isMilestoneRollLocked:true);
      }

      private boolean isBasicallyRollable() {
         return !this.hasTag((UNGP_RulesManager.URule.Tags)UNGP_RulesManager.URule.Tags.NO_ROLL);
      }

      public boolean isMilestone() {
         return this.hasTag((UNGP_RulesManager.URule.Tags)UNGP_RulesManager.URule.Tags.MILESTONE);
      }

      public static enum Tags {

         NO_ROLL("no_roll"),
         MILESTONE("milestone");
         private final String id;
         // $FF: synthetic field
         private static final UNGP_RulesManager.URule.Tags[] $VALUES = $values();


         private Tags(String id) {
            this.id = id;
         }

         // $FF: synthetic method
         private static UNGP_RulesManager.URule.Tags[] $values() {
            return new UNGP_RulesManager.URule.Tags[]{NO_ROLL, MILESTONE};
         }

      }
   }

   public static class UNGP_RuleSorter implements Comparator {

      public int compare(UNGP_RulesManager.URule o1, UNGP_RulesManager.URule o2) {
         int compare = Boolean.compare(!o1.isPositive(), !o2.isPositive());
         if(compare == 0) {
            compare = Boolean.compare(o1.isGolden(), o2.isGolden());
            if(compare == 0) {
               compare = Boolean.compare(!o1.isMilestone(), !o2.isMilestone());
               if(compare == 0) {
                  compare = Integer.compare(Math.abs(o1.getCost()), Math.abs(o2.getCost()));
                  if(compare == 0) {
                     compare = o1.getId().compareTo(o2.getId());
                  }
               }
            }
         }

         compare = -compare;
         return compare;
      }
   }
}
