package ungp.scripts.campaign.specialist.rules;

import com.fs.starfarer.api.Global;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.lazywizard.lazylib.JSONUtils;
import org.lazywizard.lazylib.JSONUtils.CommonDataJSONObject;
import ungp.scripts.campaign.specialist.rules.UNGP_RulesManager;

public class UNGP_RulePickPresetManager {

   public static void save(String presetSlot, List rules) {
      try {
         CommonDataJSONObject e = JSONUtils.loadCommonJSON(getSaveFileName(presetSlot));

         try {
            HashSet ruleStrings = new HashSet();
            Iterator var4 = rules.iterator();

            while(true) {
               if(!var4.hasNext()) {
                  e.put("rules", ruleStrings);
                  e.save();
                  break;
               }

               UNGP_RulesManager.URule rule = (UNGP_RulesManager.URule)var4.next();
               ruleStrings.add(rule.getId());
            }
         } catch (Throwable var7) {
            if(e != null) {
               try {
                  e.close();
               } catch (Throwable var6) {
                  var7.addSuppressed(var6);
               }
            }

            throw var7;
         }

         if(e != null) {
            e.close();
         }

      } catch (Exception var8) {
         throw new RuntimeException(var8);
      }
   }

   public static List load(String presetSlot) {
      try {
         CommonDataJSONObject e = JSONUtils.loadCommonJSON(getSaveFileName(presetSlot));

         ArrayList var11;
         try {
            JSONArray rulesArray = e.getJSONArray("rules");
            HashSet ruleStrings = new HashSet();

            for(int rules = 0; rules < rulesArray.length(); ++rules) {
               ruleStrings.add(rulesArray.optString(rules, ""));
            }

            ArrayList var10 = new ArrayList();
            Iterator var5 = UNGP_RulesManager.getAllRulesCopy().iterator();

            while(var5.hasNext()) {
               UNGP_RulesManager.URule rule = (UNGP_RulesManager.URule)var5.next();
               if(ruleStrings.contains(rule.getId())) {
                  var10.add(rule);
               }
            }

            var11 = var10;
         } catch (Throwable var8) {
            if(e != null) {
               try {
                  e.close();
               } catch (Throwable var7) {
                  var8.addSuppressed(var7);
               }
            }

            throw var8;
         }

         if(e != null) {
            e.close();
         }

         return var11;
      } catch (Exception var9) {
         return new ArrayList();
      }
   }

   public static boolean isPresetExists(String presetSlot) {
      return Global.getSettings().fileExistsInCommon(getSaveFileName(presetSlot));
   }

   public static String getSaveFileName(String presetSlot) {
      return presetSlot;
   }
}
