package ungp.scripts.campaign.specialist.rules;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings.Difficulty;
import ungp.scripts.campaign.specialist.rules.UNGP_RulesManager;

public class UNGP_RulePickHelper {

   public static List generateUnmetReasons(List rules, Difficulty difficulty) {
      ArrayList reasons = new ArrayList();
      if(rules.isEmpty()) {
         reasons.add(new UNGP_RulePickHelper.UnmetReason(UNGP_RulePickHelper.UnmetReasonType.EMPTY_RULES));
         return reasons;
      } else if(difficulty == null) {
         reasons.add(new UNGP_RulePickHelper.UnmetReason(UNGP_RulePickHelper.UnmetReasonType.GENERAL));
         return reasons;
      } else {
         int cost = 0;

         UNGP_RulesManager.URule goldenRuleSize;
         for(Iterator size = rules.iterator(); size.hasNext(); cost += goldenRuleSize.getCost()) {
            goldenRuleSize = (UNGP_RulesManager.URule)size.next();
         }

         if(cost < 0) {
            reasons.add(new UNGP_RulePickHelper.UnmetReason(UNGP_RulePickHelper.UnmetReasonType.WRONG_COST));
         }

         int var8 = rules.size();
         int var9 = 0;
         Iterator var6 = rules.iterator();

         while(var6.hasNext()) {
            UNGP_RulesManager.URule rule = (UNGP_RulesManager.URule)var6.next();
            if(rule.isGolden()) {
               ++var9;
            }
         }

         if(var9 > 1) {
            reasons.add(new UNGP_RulePickHelper.UnmetReason(UNGP_RulePickHelper.UnmetReasonType.GOLDEN_MORE_THAN_ONE));
         }

         if(var8 > difficulty.maxRules) {
            reasons.add(new UNGP_RulePickHelper.UnmetReason(UNGP_RulePickHelper.UnmetReasonType.TOO_MUCH_RULES));
         }

         if(var8 < difficulty.minRules) {
            reasons.add(new UNGP_RulePickHelper.UnmetReason(UNGP_RulePickHelper.UnmetReasonType.TOO_FEW_RULES));
         }

         return reasons;
      }
   }

   public static boolean hasUnmetReasons(List rules, Difficulty difficulty) {
      return !generateUnmetReasons(rules, difficulty).isEmpty();
   }

   public static class UnmetReason {

      private UNGP_RulePickHelper.UnmetReasonType type;
      private Object[] params;


      public UnmetReason(UNGP_RulePickHelper.UnmetReasonType type, Object ... params) {
         this.type = type;
         this.params = params;
      }

      public UnmetReason(UNGP_RulePickHelper.UnmetReasonType type) {
         this.type = type;
      }

      public UNGP_RulePickHelper.UnmetReasonType getType() {
         return this.type;
      }
   }

   public static enum UnmetReasonType {

      WRONG_COST("unmet_wrong_cost"),
      GOLDEN_MORE_THAN_ONE("unmet_golden_more_than_one"),
      TOO_FEW_RULES("unmet_too_few_rules"),
      TOO_MUCH_RULES("unmet_too_much_rules"),
      EMPTY_RULES("unmet_empty_rules"),
      GENERAL("unmet_general");
      final String i18n_key;
      // $FF: synthetic field
      private static final UNGP_RulePickHelper.UnmetReasonType[] $VALUES = $values();


      public String getI18nKey() {
         return this.i18n_key;
      }

      private UnmetReasonType(String i18n_key) {
         this.i18n_key = i18n_key;
      }

      // $FF: synthetic method
      private static UNGP_RulePickHelper.UnmetReasonType[] $values() {
         return new UNGP_RulePickHelper.UnmetReasonType[]{WRONG_COST, GOLDEN_MORE_THAN_ONE, TOO_FEW_RULES, TOO_MUCH_RULES, EMPTY_RULES, GENERAL};
      }

   }
}
