package ungp.scripts.campaign.specialist.rules;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.graphics.SpriteAPI;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import ungp.api.rules.UNGP_BaseRuleEffect;
import ungp.scripts.utils.UNGPUtils;

public final class UNGP_RuleInfoLoader {

   private static final String FILE_PATH = "data/campaign/UNGP_rules.csv";


   public static List loadAllRuleInformation() {
      ArrayList infos = new ArrayList();

      try {
         ClassLoader e = Global.getSettings().getScriptClassLoader();
         JSONArray ruleInfos = Global.getSettings().getMergedSpreadsheetDataForMod("id", "data/campaign/UNGP_rules.csv", "ungp");
         int i = 0;

         for(int len = ruleInfos.length(); i < len; ++i) {
            JSONObject row = ruleInfos.getJSONObject(i);
            String id = row.optString("id", "[EMPTY]");
            if(!UNGPUtils.isEmpty(id)) {
               String name = row.optString("name", "[EMPTY]");
               String shortDesc = row.optString("short", "[EMPTY]");
               String desc = row.optString("desc", "[EMPTY]");
               int cost = row.optInt("cost", 0);
               boolean isBonus = row.optBoolean("isBonus", false);
               boolean isGolden = row.optBoolean("isGolden", false);
               String spritePath = row.optString("spritePath", "[EMPTY]");
               String extra1 = row.optString("extra1", "[EMPTY]");
               String extra2 = row.optString("extra2", "[EMPTY]");
               String source = row.optString("source", "[EMPTY]");
               String effectPluginName = row.getString("effectPlugin");
               String tags = row.optString("tags", "[EMPTY]");
               ArrayList tagList = new ArrayList();
               if(!UNGPUtils.isEmpty(tags)) {
                  String[] effectClass = tags.split(",");
                  String[] ruleEffect = effectClass;
                  int sprite = effectClass.length;

                  for(int info = 0; info < sprite; ++info) {
                     String s = ruleEffect[info];
                     tagList.add(s.trim());
                  }
               }

               Class var29 = e.loadClass(effectPluginName);
               UNGP_BaseRuleEffect var26 = (UNGP_BaseRuleEffect)var29.newInstance();
               if(UNGPUtils.isEmpty(spritePath)) {
                  spritePath = "graphics/ui/icons/64x_xcircle.png";
               }

               SpriteAPI var27 = Global.getSettings().getSprite(spritePath);
               if(var27 == null || var27.getHeight() < 1.0F) {
                  Global.getSettings().loadTexture(spritePath);
               }

               UNGP_RuleInfoLoader.UNGP_RuleInfo var28 = new UNGP_RuleInfoLoader.UNGP_RuleInfo(id, name, shortDesc, desc, cost, isBonus, isGolden, spritePath, extra1, extra2, source, var26, tagList);
               infos.add(var28);
            }
         }

         return infos;
      } catch (Exception var25) {
         Global.getLogger(UNGP_RuleInfoLoader.class).error(var25);
         throw new RuntimeException("Failed to load UNGP rules:", var25);
      }
   }

   public static final class UNGP_RuleInfo {

      private String id = "[EMPTY]";
      private String name = "[EMPTY]";
      private String shortDesc = "[EMPTY]";
      private String desc = "[EMPTY]";
      private int cost = 0;
      private boolean isBonus = false;
      private boolean isGolden = false;
      private String spritePath = "[EMPTY]";
      private String extra1 = "[EMPTY]";
      private String extra2 = "[EMPTY]";
      private String source = "[EMPTY]";
      private UNGP_BaseRuleEffect effectPlugin;
      private List tags;


      public UNGP_RuleInfo() {
      }

      public UNGP_RuleInfo(String id, String name, String shortDesc, String desc, int cost, boolean isBonus, boolean isGolden, String spritePath, String extra1, String extra2, String source, UNGP_BaseRuleEffect effectPlugin, List tags) {
         this.id = id;
         this.name = name;
         this.shortDesc = shortDesc;
         this.desc = desc;
         this.cost = cost;
         this.spritePath = spritePath;
         this.isBonus = isBonus;
         this.isGolden = isGolden;
         this.extra1 = extra1;
         this.extra2 = extra2;
         this.source = source;
         this.effectPlugin = effectPlugin;
         this.tags = tags;
      }

      public String getId() {
         return this.id;
      }

      public String getName() {
         return this.name;
      }

      public String getShortDesc() {
         return this.shortDesc;
      }

      public String getDesc() {
         return this.desc;
      }

      public String getExtra1() {
         return this.extra1;
      }

      public String getExtra2() {
         return this.extra2;
      }

      public String getSource() {
         return this.source;
      }

      public String getSpritePath() {
         return this.spritePath;
      }

      public boolean isBonus() {
         return this.isBonus;
      }

      public int getCost() {
         return this.cost;
      }

      public UNGP_BaseRuleEffect getEffectPlugin() {
         return this.effectPlugin;
      }

      public boolean isGolden() {
         return this.isGolden;
      }

      public List getTags() {
         return this.tags;
      }
   }
}
