package ungp.scripts.campaign.specialist.listeners;

import com.fs.starfarer.api.campaign.BaseCampaignEventListener;
import com.fs.starfarer.api.campaign.EngagementResultForFleetAPI;
import com.fs.starfarer.api.combat.EngagementResultAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import java.util.HashSet;
import java.util.Iterator;
import ungp.scripts.campaign.specialist.UNGP_SpecialistManager;
import ungp.scripts.campaign.specialist.challenges.UNGP_ChallengeManager;
import ungp.scripts.campaign.specialist.challenges.UNGP_ChallengeProgress;
import ungp.scripts.campaign.specialist.challenges.UNGP_ChallengeProgress.ProgressState;

public class UNGP_CampaignEventListener extends BaseCampaignEventListener {

   public UNGP_CampaignEventListener() {
      super(false);
   }

   public void reportPlayerEngagement(EngagementResultAPI result) {
      if(UNGP_SpecialistManager.isSpecialistMode()) {
         EngagementResultForFleetAPI anotherSideResult;
         if(result.didPlayerWin()) {
            anotherSideResult = result.getLoserResult();
         } else {
            anotherSideResult = result.getWinnerResult();
         }

         HashSet damagedMembers = new HashSet();
         damagedMembers.addAll(anotherSideResult.getDestroyed());
         damagedMembers.addAll(anotherSideResult.getDisabled());
         float damagedDp = 0.0F;

         Iterator var5;
         float dp;
         for(var5 = damagedMembers.iterator(); var5.hasNext(); damagedDp += Math.min(50.0F, dp)) {
            FleetMemberAPI progress = (FleetMemberAPI)var5.next();
            dp = progress.getUnmodifiedDeploymentPointsCost();
         }

         var5 = UNGP_ChallengeManager.getUndergoingChallenges().iterator();

         while(var5.hasNext()) {
            UNGP_ChallengeProgress progress1 = (UNGP_ChallengeProgress)var5.next();
            if(progress1.getState() == ProgressState.RUNNING) {
               progress1.addDefeatedDp(damagedDp);
            }
         }

      }
   }
}
