package ungp.scripts.campaign.specialist.dialog;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.Script;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.InteractionDialogPlugin;
import com.fs.starfarer.api.campaign.OptionPanelAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.combat.EngagementResultAPI;
import com.fs.starfarer.api.ui.IntelUIAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import ungp.scripts.campaign.UNGP_InGameData;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings.Difficulty;
import ungp.scripts.campaign.specialist.rules.UNGP_RulePickHelper;
import ungp.scripts.campaign.specialist.rules.UNGP_RulesManager;
import ungp.scripts.campaign.specialist.rules.UNGP_RulesManager.URule;
import ungp.scripts.campaign.ui.UNGP_RulePickPanelDelegate;
import ungp.scripts.campaign.ui.UNGP_RulePickPanelPlugin;
import ungp.scripts.utils.Constants;
import ungp.scripts.utils.UNGP_Feedback;

public class UNGP_RepickRulesDialog implements InteractionDialogPlugin {

   private Object OptionRepick = new Object();
   private Object OptionConfirm = new Object();
   private Object OptionLeave = new Object();
   private InteractionDialogAPI dialog;
   private OptionPanelAPI options;
   private TextPanelAPI textPanel;
   private IntelUIAPI intelUI;
   private IntelInfoPlugin intelPlugin;
   private List pickedList;
   private boolean couldRepick = false;


   public UNGP_RepickRulesDialog(IntelUIAPI ui, IntelInfoPlugin intelPlugin) {
      this.intelUI = ui;
      this.intelPlugin = intelPlugin;
      this.pickedList = new ArrayList();
   }

   public void init(InteractionDialogAPI dialog) {
      this.dialog = dialog;
      this.options = dialog.getOptionPanel();
      this.textPanel = dialog.getTextPanel();
      this.textPanel.addPara(Constants.rules_i18n.get("repick_desc"));
      this.options.addOption(Constants.root_i18n.get("rulepick_button"), this.OptionRepick);
      this.options.addOption(Constants.root_i18n.get("confirm"), this.OptionConfirm);
      this.options.addOption(Constants.root_i18n.get("leave"), this.OptionLeave);
      dialog.setOptionOnEscape((String)null, this.OptionLeave);
   }

   public void optionSelected(String optionText, Object optionData) {
      UNGP_InGameData inGameData = UNGP_InGameData.getDataInSave();
      if(optionData == this.OptionRepick) {
         this.pickedList.clear();
         this.couldRepick = false;
         float width = Global.getSettings().getScreenWidth();
         float height = Global.getSettings().getScreenHeight();
         final Difficulty difficulty = inGameData.getDifficulty();
         UNGP_RulesManager.setStaticDifficulty(difficulty);
         UNGP_RulePickPanelPlugin plugin = UNGP_RulePickPanelPlugin.createPlugin(difficulty, this.pickedList, inGameData.getCompletedChallenges(), new Script() {
            public void run() {
               UNGP_RepickRulesDialog.this.textPanel.addPara(Constants.root_i18n.get("hardmodeDes"));
               TooltipMakerAPI tooltip = UNGP_RepickRulesDialog.this.textPanel.beginTooltip();
               Iterator var2 = UNGP_RepickRulesDialog.this.pickedList.iterator();

               while(var2.hasNext()) {
                  URule rule = (URule)var2.next();
                  TooltipMakerAPI imageMaker = tooltip.beginImageWithText(rule.getSpritePath(), 32.0F);
                  imageMaker.addPara(rule.getName(), rule.getCorrectColor(), 0.0F);
                  rule.addDesc(imageMaker, 0.0F);
                  tooltip.addImageWithText(3.0F);
               }

               UNGP_RepickRulesDialog.this.couldRepick = true;
               if(UNGP_RulePickHelper.hasUnmetReasons(UNGP_RepickRulesDialog.this.pickedList, difficulty)) {
                  tooltip.addPara(Constants.root_i18n.get("rulepick_notMeet"), Misc.getNegativeHighlightColor(), 5.0F);
                  UNGP_RepickRulesDialog.this.couldRepick = false;
               }

               UNGP_RepickRulesDialog.this.textPanel.addTooltip();
            }
         }, (Script)null);
         this.dialog.showCustomVisualDialog(width, height, new UNGP_RulePickPanelDelegate(plugin, this.dialog, this.getMemoryMap()));
      }

      if(optionData == this.OptionConfirm) {
         if(!this.pickedList.isEmpty() && this.couldRepick) {
            inGameData.reduceTimesToChangeSpecialistMode();
            inGameData.saveActivatedRules(this.pickedList);
            UNGP_Feedback.setFeedBackList(this.pickedList);
            UNGP_Feedback.resetFeedbackSent();
            UNGP_RulesManager.updateRulesCache();
         }

         this.dialog.dismiss();
         this.intelUI.updateUIForItem(this.intelPlugin);
      }

      if(optionData == this.OptionLeave) {
         this.dialog.dismiss();
         this.intelUI.updateUIForItem(this.intelPlugin);
      }

   }

   public void optionMousedOver(String optionText, Object optionData) {
   }

   public void advance(float amount) {
      if(this.pickedList != null) {
         this.options.setEnabled(this.OptionConfirm, !this.pickedList.isEmpty() && this.couldRepick);
      }

   }

   public void backFromEngagement(EngagementResultAPI battleResult) {
   }

   public Object getContext() {
      return null;
   }

   public Map getMemoryMap() {
      return null;
   }
}
