package ungp.scripts.campaign.specialist.challenges;


public final class UNGP_ChallengeProgress {

   private String challengeId;
   private int elapsedMonth = 0;
   private float defeatedDp = 0.0F;
   private UNGP_ChallengeProgress.ProgressState state;


   public UNGP_ChallengeProgress(String challengeId) {
      this.state = UNGP_ChallengeProgress.ProgressState.RUNNING;
      this.challengeId = challengeId;
   }

   public void setState(UNGP_ChallengeProgress.ProgressState state) {
      this.state = state;
   }

   public String getChallengeId() {
      return this.challengeId;
   }

   public int getElapsedMonth() {
      return this.elapsedMonth;
   }

   public float getDefeatedDp() {
      return this.defeatedDp;
   }

   public void advanceMonth() {
      ++this.elapsedMonth;
   }

   public void addDefeatedDp(float dp) {
      this.defeatedDp += dp;
   }

   public UNGP_ChallengeProgress.ProgressState getState() {
      return this.state;
   }

   public static enum ProgressState {

      RUNNING,
      CANCELLED,
      COMPLETED;
      // $FF: synthetic field
      private static final UNGP_ChallengeProgress.ProgressState[] $VALUES = $values();


      // $FF: synthetic method
      private static UNGP_ChallengeProgress.ProgressState[] $values() {
         return new UNGP_ChallengeProgress.ProgressState[]{RUNNING, CANCELLED, COMPLETED};
      }

   }
}
