package ungp.scripts.campaign.specialist.challenges;

import com.fs.starfarer.api.Global;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import ungp.scripts.campaign.UNGP_InGameData;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings.Difficulty;
import ungp.scripts.campaign.specialist.challenges.UNGP_ChallengeInfo;
import ungp.scripts.campaign.specialist.challenges.UNGP_ChallengeLoader;
import ungp.scripts.campaign.specialist.challenges.UNGP_ChallengeProgress;
import ungp.scripts.campaign.specialist.intel.UNGP_ChallengeIntel;
import ungp.scripts.campaign.specialist.rules.UNGP_RulesManager.URule;

public class UNGP_ChallengeManager {

   private static final Map ID_TO_CHALLENGE_INFO_MAP = new HashMap();
   public static final String LOCK_REPICK_KEY = "UNGP_challenge_lockRepick";
   private static final transient List TEMPORARY_COMPLETED_CHALLENGES = new ArrayList();


   public static void updateChallengeProgress(UNGP_InGameData inGameData) {
      if(Global.getSector().getIntelManager().hasIntelOfClass(UNGP_ChallengeIntel.class)) {
         UNGP_ChallengeIntel challengeIntel = (UNGP_ChallengeIntel)Global.getSector().getIntelManager().getFirstIntel(UNGP_ChallengeIntel.class);
         challengeIntel.updateChallengeProgress(inGameData);
      }

   }

   public static List getUndergoingChallenges() {
      if(Global.getSector().getIntelManager().hasIntelOfClass(UNGP_ChallengeIntel.class)) {
         UNGP_ChallengeIntel challengeIntel = (UNGP_ChallengeIntel)Global.getSector().getIntelManager().getFirstIntel(UNGP_ChallengeIntel.class);
         return challengeIntel.getUnderGoingChallenges();
      } else {
         return new ArrayList();
      }
   }

   public static void initOrReloadChallengeInfos() {
      ID_TO_CHALLENGE_INFO_MAP.clear();
      ID_TO_CHALLENGE_INFO_MAP.putAll(UNGP_ChallengeLoader.loadAllInfos());
   }

   public static UNGP_ChallengeIntel confirmChallenges(UNGP_InGameData inGameData) {
      if(!isDifficultyEnough(inGameData.getDifficulty())) {
         return null;
      } else {
         Global.getSector().getPersistentData().put("UNGP_challenge_start", Boolean.valueOf(true));
         if(!Global.getSector().getIntelManager().hasIntelOfClass(UNGP_ChallengeIntel.class)) {
            ArrayList challengeProgresses = new ArrayList();
            List runnableChallenges = getRunnableChallenges(inGameData);
            Iterator challengeIntel = runnableChallenges.iterator();

            while(challengeIntel.hasNext()) {
               UNGP_ChallengeInfo challenge = (UNGP_ChallengeInfo)challengeIntel.next();
               UNGP_ChallengeProgress progress = new UNGP_ChallengeProgress(challenge.getId());
               challengeProgresses.add(progress);
            }

            if(!challengeProgresses.isEmpty()) {
               UNGP_ChallengeIntel challengeIntel1 = new UNGP_ChallengeIntel(challengeProgresses);
               Global.getSector().getIntelManager().addIntel(challengeIntel1);
               return challengeIntel1;
            }
         }

         return null;
      }
   }

   public static List getRunnableChallenges(UNGP_InGameData inGameData) {
      return getRunnableChallenges(inGameData.getDifficulty(), inGameData.getActivatedRules(), inGameData.getCompletedChallenges());
   }

   public static List getRunnableChallenges(Difficulty difficulty, List rules, List completedChallenges) {
      ArrayList var9 = new ArrayList(rules);
      if(!isDifficultyEnough(difficulty)) {
         return new ArrayList();
      } else {
         ArrayList activeRuleIds = new ArrayList();
         int positiveRuleAmount = 0;
         Iterator challengeInfosCopy = var9.iterator();

         while(challengeInfosCopy.hasNext()) {
            URule runnableChallenges = (URule)challengeInfosCopy.next();
            activeRuleIds.add(runnableChallenges.getId());
            if(runnableChallenges.isPositive()) {
               ++positiveRuleAmount;
            }
         }

         List var10 = getChallengeInfosCopy();
         ArrayList var11 = new ArrayList();
         Iterator var7 = var10.iterator();

         while(var7.hasNext()) {
            UNGP_ChallengeInfo challengeInfo = (UNGP_ChallengeInfo)var7.next();
            if(!completedChallenges.contains(challengeInfo.getId()) && !challengeInfo.isAbovePositiveLimitation(positiveRuleAmount) && challengeInfo.isRulesRequiredIncluded(activeRuleIds)) {
               var11.add(challengeInfo);
            }
         }

         return var11;
      }
   }

   public static boolean isDifficultyEnough(Difficulty difficulty) {
      return difficulty == Difficulty.ALPHA || difficulty == Difficulty.OMEGA;
   }

   public static boolean isChallengesStarted() {
      return Global.getSector().getPersistentData().containsKey("UNGP_challenge_start");
   }

   public static boolean isRepickLockedByChallenges() {
      Map persistentData = Global.getSector().getPersistentData();
      Boolean locked = (Boolean)persistentData.get("UNGP_challenge_lockRepick");
      return locked != null && locked.booleanValue();
   }

   public static void setRepickLock(boolean lock) {
      Global.getSector().getPersistentData().put("UNGP_challenge_lockRepick", Boolean.valueOf(lock));
   }

   public static UNGP_ChallengeInfo getChallengeInfo(String id) {
      return (UNGP_ChallengeInfo)ID_TO_CHALLENGE_INFO_MAP.get(id);
   }

   public static List getChallengeInfosCopy() {
      return new ArrayList(ID_TO_CHALLENGE_INFO_MAP.values());
   }

   public static void setTemporaryCompletedChallenges(List challenges) {
      TEMPORARY_COMPLETED_CHALLENGES.clear();
      TEMPORARY_COMPLETED_CHALLENGES.addAll(challenges);
   }

   public static List getTemporaryCompletedChallenges() {
      return TEMPORARY_COMPLETED_CHALLENGES;
   }

}
