package ungp.scripts.campaign.specialist.challenges;

import com.fs.starfarer.api.Global;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import ungp.scripts.campaign.specialist.challenges.UNGP_ChallengeInfo;

public class UNGP_ChallengeLoader {

   public static final String EMPTY = "[EMPTY]";
   private static final String FILE_PATH = "data/campaign/UNGP_challenges.csv";


   public static Map loadAllInfos() {
      HashMap challengeInfoMap = new HashMap();

      try {
         JSONArray e = Global.getSettings().getMergedSpreadsheetDataForMod("id", "data/campaign/UNGP_challenges.csv", "ungp");
         int i = 0;

         for(int len = e.length(); i < len; ++i) {
            JSONObject row = e.getJSONObject(i);
            String id = row.optString("id", "[EMPTY]");
            if(!isEmpty(id)) {
               String rulesRequired = row.optString("rulesRequired", "[EMPTY]");
               if(!isEmpty(rulesRequired)) {
                  ArrayList rulesRequiredList = new ArrayList();
                  int durationByMonth;
                  int dpToDefeat;
                  if(!isEmpty(rulesRequired)) {
                     String[] name = rulesRequired.split(",");
                     String[] positiveLimitation = name;
                     durationByMonth = name.length;

                     for(dpToDefeat = 0; dpToDefeat < durationByMonth; ++dpToDefeat) {
                        String needMaxLevel = positiveLimitation[dpToDefeat];
                        rulesRequiredList.add(needMaxLevel.trim());
                     }
                  }

                  String var17 = row.optString("name", "[EMPTY]");
                  int var18 = row.optInt("positiveLimitation", -1);
                  durationByMonth = row.optInt("durationByMonth", -1);
                  dpToDefeat = row.optInt("dpToDefeat", -1);
                  boolean var19 = row.optBoolean("needMaxLevel", true);
                  boolean canReselectRules = row.optBoolean("canReselectRules", true);
                  String milestoneToUnlock = row.optString("milestoneToUnlock", "");
                  UNGP_ChallengeInfo challengeInfo = new UNGP_ChallengeInfo(id, var17, rulesRequiredList, var18, durationByMonth, dpToDefeat, var19, canReselectRules, milestoneToUnlock);
                  if(challengeInfo.isValid()) {
                     challengeInfoMap.put(id, challengeInfo);
                  }
               }
            }
         }

         return challengeInfoMap;
      } catch (Exception var16) {
         Global.getLogger(UNGP_ChallengeLoader.class).error(var16);
         throw new RuntimeException("Failed to load UNGP challenges:", var16);
      }
   }

   public static boolean isEmpty(String target) {
      return target == null || target.isEmpty() || target.contentEquals("[EMPTY]");
   }
}
