package ungp.scripts.campaign.specialist.challenges;

import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import ungp.scripts.campaign.specialist.challenges.UNGP_ChallengeProgress;
import ungp.scripts.campaign.specialist.rules.UNGP_RulesManager;
import ungp.scripts.campaign.specialist.rules.UNGP_RulesManager.URule;
import ungp.scripts.utils.Constants;

public final class UNGP_ChallengeInfo {

   private String id;
   private String name;
   private List rulesRequired;
   private int positiveLimitation;
   private int durationByMonth;
   private int dpToDefeat;
   private boolean needMaxLevel;
   private boolean canReselectRules;
   private URule milestoneToUnlock;
   private boolean isValid = true;


   public UNGP_ChallengeInfo(String id, String name, List rulesRequired, int positiveLimitation, int durationByMonth, int dpToDefeat, boolean needMaxLevel, boolean canReselectRules, String milestoneToUnlock) {
      this.id = id;
      this.name = name;
      this.positiveLimitation = positiveLimitation;
      this.durationByMonth = durationByMonth;
      this.needMaxLevel = needMaxLevel;
      this.canReselectRules = canReselectRules;
      this.dpToDefeat = dpToDefeat;
      this.rulesRequired = new ArrayList();
      Iterator mileStoneUnlock = rulesRequired.iterator();

      while(mileStoneUnlock.hasNext()) {
         String ruleID = (String)mileStoneUnlock.next();
         URule rule = URule.getByID(ruleID);
         if(rule == null) {
            this.isValid = false;
            return;
         }

         this.rulesRequired.add(rule);
      }

      URule mileStoneUnlock1 = URule.getByID(milestoneToUnlock);
      if(mileStoneUnlock1 != null) {
         this.milestoneToUnlock = mileStoneUnlock1;
      } else {
         this.isValid = false;
      }
   }

   public String getId() {
      return this.id;
   }

   public String getName() {
      return this.name;
   }

   public List getRulesRequired() {
      return this.rulesRequired;
   }

   public boolean isRulesRequiredIncluded(List rules) {
      ArrayList rulesRequiredIDs = new ArrayList();
      Iterator var3 = this.rulesRequired.iterator();

      while(var3.hasNext()) {
         URule rule = (URule)var3.next();
         rulesRequiredIDs.add(rule.getId());
      }

      return rules.containsAll(rulesRequiredIDs);
   }

   public int getPositiveLimitation() {
      return this.positiveLimitation;
   }

   public boolean isPositiveLimited() {
      return this.positiveLimitation != -1;
   }

   public boolean isAbovePositiveLimitation(int ruleAmount) {
      return this.isPositiveLimited() && ruleAmount > this.positiveLimitation;
   }

   public boolean shouldBeCancelled(int positiveRuleAmount, List currentRuleIDs) {
      return this.isAbovePositiveLimitation(positiveRuleAmount) || !this.isRulesRequiredIncluded(currentRuleIDs);
   }

   public int getDurationByMonth() {
      return this.durationByMonth;
   }

   public int getDpToDefeat() {
      return this.dpToDefeat;
   }

   public boolean isNeedMaxLevel() {
      return this.needMaxLevel;
   }

   public URule getMilestoneToUnlock() {
      return this.milestoneToUnlock;
   }

   public String getConnectedRuleNames() {
      StringBuilder sb = new StringBuilder();
      Iterator var2 = this.rulesRequired.iterator();

      while(var2.hasNext()) {
         URule rule = (URule)var2.next();
         sb.append(rule.getName()).append("+");
      }

      sb.deleteCharAt(sb.length() - 1);
      return sb.toString();
   }

   public String getConnectedRuleNamesReplacedWithEscapeCharacter() {
      StringBuilder sb = new StringBuilder();

      for(int i = 0; i < this.rulesRequired.size(); ++i) {
         sb.append(" %s ");
         sb.append("+");
      }

      sb.deleteCharAt(sb.length() - 1);
      return sb.toString();
   }

   public String[] getRuleNames() {
      String[] array = new String[this.rulesRequired.size()];

      for(int i = 0; i < array.length; ++i) {
         array[i] = ((URule)this.rulesRequired.get(i)).getName();
      }

      return array;
   }

   public Color[] getRuleColors() {
      Color[] array = new Color[this.rulesRequired.size()];

      for(int i = 0; i < array.length; ++i) {
         URule rule = (URule)this.rulesRequired.get(i);
         array[i] = rule.getCorrectColor().darker();
      }

      return array;
   }

   public void createTooltip(TooltipMakerAPI tooltip, float pad, UNGP_ChallengeProgress progress) {
      URule unlockRule = this.milestoneToUnlock;
      if(unlockRule != null) {
         TooltipMakerAPI imageTooltip = tooltip.beginImageWithText(unlockRule.getSpritePath(), 64.0F);
         imageTooltip.addPara(this.name, UNGP_RulesManager.getMilestoneColor(), 0.0F);
         Color grayColor = Misc.getGrayColor();
         this.showChallengeDetails(imageTooltip, grayColor, progress);
         tooltip.addImageWithText(pad);
      }

   }

   public void showChallengeDetails(TooltipMakerAPI tooltip, Color color, UNGP_ChallengeProgress progress) {
      Constants.rules_i18n.get("challenge_tip_rules_prefix").addPara(this.getConnectedRuleNamesReplacedWithEscapeCharacter(), 5.0F, color, color, this.getRuleNames()).setHighlightColors(this.getRuleColors());
      if(this.getDurationByMonth() == -1) {
         tooltip.addPara(Constants.rules_i18n.get("challenge_tip_desc0_1"), color, 0.0F);
      } else {
         tooltip.addPara(Constants.rules_i18n.get("challenge_tip_desc0_0"), color, 0.0F);
         if(this.isNeedMaxLevel()) {
            tooltip.addPara(Constants.rules_i18n.get("challenge_tip_desc1"), color, 0.0F);
         }
      }

      if(this.getDpToDefeat() > 0) {
         if(progress != null) {
            Constants.rules_i18n.format("challenge_tip_desc4", new Object[]{this.getDpToDefeat()});
            ((int)progress.getDefeatedDp()).addPara(this.getDpToDefeat(), color, 0.0F);
         } else {
            tooltip.addPara(Constants.rules_i18n.format("challenge_tip_desc4", new Object[]{this.getDpToDefeat()}), color, 0.0F);
         }
      }

      if(this.getPositiveLimitation() >= 0) {
         tooltip.addPara(Constants.rules_i18n.format("challenge_tip_desc2", new Object[]{this.getPositiveLimitation()}), color, 0.0F);
      }

      if(!this.canReselectRules()) {
         tooltip.addPara(Constants.rules_i18n.get("challenge_tip_desc3"), color, 0.0F);
      }

   }

   public boolean canReselectRules() {
      return this.canReselectRules;
   }

   public boolean isValid() {
      return this.isValid;
   }
}
