package ungp.scripts.campaign.specialist;

import com.fs.starfarer.api.Global;
import java.awt.Color;
import java.util.Iterator;
import java.util.List;
import ungp.scripts.campaign.specialist.rules.UNGP_RulesManager.URule;

public final class UNGP_SpecialistSettings {

   /** @deprecated */
   @Deprecated
   public static final int MAX_DIFFICULTY = UNGP_SpecialistSettings.Difficulty.ALPHA.legacyLevel;
   public static final String RULES_ENABLE_IN_SIMULATION = "UNGP_rulesEnableInSimulation";


   public static UNGP_SpecialistSettings.Difficulty getChallengeMinLevelReq() {
      return UNGP_SpecialistSettings.Difficulty.ALPHA;
   }

   public static boolean rulesMeetCondition(List rules, UNGP_SpecialistSettings.Difficulty difficulty) {
      if(rules.isEmpty()) {
         return false;
      } else if(difficulty == null) {
         return false;
      } else {
         int cost = 0;

         URule goldenRuleSize;
         for(Iterator size = rules.iterator(); size.hasNext(); cost += goldenRuleSize.getCost()) {
            goldenRuleSize = (URule)size.next();
         }

         if(cost < 0) {
            return false;
         } else {
            int var7 = rules.size();
            int var8 = 0;
            Iterator var5 = rules.iterator();

            while(var5.hasNext()) {
               URule rule = (URule)var5.next();
               if(rule.isGolden()) {
                  ++var8;
               }

               if(var8 > 1) {
                  return false;
               }
            }

            return var7 <= difficulty.maxRules && var7 >= difficulty.minRules;
         }
      }
   }

   public static boolean isRulesEnabledInSimulation() {
      Boolean enable = (Boolean)Global.getSector().getPersistentData().get("UNGP_rulesEnableInSimulation");
      if(enable == null) {
         enable = Boolean.valueOf(true);
         setRulesEnabledInSimulation(true);
      }

      return enable.booleanValue();
   }

   public static void setRulesEnabledInSimulation(boolean enable) {
      Global.getSector().getPersistentData().put("UNGP_rulesEnableInSimulation", Boolean.valueOf(enable));
   }

   public static String getSpecialistModeIconPath() {
      return "graphics/ungp/icons/UNGP_specialist_mode_logo.png";
   }


   public static enum Difficulty {

      GAMMA("Gamma", 1, 0.0F, "graphics/ungp/icons/UNGP_difficulty_gamma.png", new Color(232, 154, 65), 4, 8),
      BETA("Beta", 10, 0.5F, "graphics/ungp/icons/UNGP_difficulty_beta.png", new Color(179, 225, 41), 8, 20),
      ALPHA("Alpha", 20, 1.0F, "graphics/ungp/icons/UNGP_difficulty_alpha.png", new Color(119, 255, 230), 12, 42),
      OMEGA("Omega", 30, 1.5F, "graphics/ungp/icons/UNGP_difficulty_omega.png", new Color(145, 70, 255), 20, 64);
      public final String name;
      /** @deprecated */
      @Deprecated
      public final int legacyLevel;
      public final float extraValueMultiplier;
      public final String spritePath;
      public final Color color;
      public final int minRules;
      public final int maxRules;
      // $FF: synthetic field
      private static final UNGP_SpecialistSettings.Difficulty[] $VALUES = $values();


      private Difficulty(String name, int legacyLevel, float extraValueMultiplier, String spritePath, Color color, int minRules, int maxRules) {
         this.name = name;
         this.legacyLevel = legacyLevel;
         this.extraValueMultiplier = extraValueMultiplier;
         this.spritePath = spritePath;
         this.color = color;
         this.minRules = minRules;
         this.maxRules = maxRules;
      }

      public float getLinearValue(float base, float fullExtraValue) {
         return base + fullExtraValue * this.extraValueMultiplier;
      }

      public float getLinearValue(float base, float fullExtraValue, float maxOrMin) {
         return fullExtraValue > 0.0F?Math.min(this.getLinearValue(base, fullExtraValue), maxOrMin):Math.max(this.getLinearValue(base, fullExtraValue), maxOrMin);
      }

      public static UNGP_SpecialistSettings.Difficulty convertLegacyLevelToDifficulty(int legacyLevel) {
         UNGP_SpecialistSettings.Difficulty[] var1 = values();
         int var2 = var1.length;

         for(int var3 = 0; var3 < var2; ++var3) {
            UNGP_SpecialistSettings.Difficulty value = var1[var3];
            if(value.legacyLevel == legacyLevel) {
               return value;
            }
         }

         return GAMMA;
      }

      // $FF: synthetic method
      private static UNGP_SpecialistSettings.Difficulty[] $values() {
         return new UNGP_SpecialistSettings.Difficulty[]{GAMMA, BETA, ALPHA, OMEGA};
      }

   }
}
