package ungp.scripts.campaign.specialist;

import com.fs.starfarer.api.campaign.BuffManagerAPI.Buff;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import ungp.api.rules.tags.UNGP_PlayerFleetMemberTag;

public class UNGP_PlayerFleetMemberBuff implements Buff {

   private static transient boolean shouldForceSyncNextStep = false;
   private transient UNGP_PlayerFleetMemberTag tag;
   private String id;
   private float dur;


   public UNGP_PlayerFleetMemberBuff(UNGP_PlayerFleetMemberTag tag, float dur) {
      this.id = tag.getBuffID();
      this.dur = dur;
      this.tag = tag;
   }

   public void advance(float days) {
      this.dur -= days;
   }

   public void apply(FleetMemberAPI member) {
      if(this.tag != null) {
         this.tag.applyPlayerFleetMemberInCampaign(member);
      }

   }

   public String getId() {
      return this.id;
   }

   public boolean isExpired() {
      return this.dur <= 0.0F;
   }

   public float getDur() {
      return this.dur;
   }

   public void setDur(float dur) {
      this.dur = dur;
   }

   public void setTag(UNGP_PlayerFleetMemberTag tag) {
      if(this.tag == null) {
         this.id = tag.getBuffID();
         this.tag = tag;
      }

   }

   public static boolean isShouldForceSyncNextStep() {
      return shouldForceSyncNextStep;
   }

   public static void forceSyncNextStep() {
      shouldForceSyncNextStep = true;
   }

   public static void completeForceSync() {
      shouldForceSyncNextStep = false;
   }

}
