package ungp.scripts.campaign.everyframe;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.util.IntervalUtil;
import java.util.HashMap;
import java.util.Iterator;

public final class UNGP_UITimeScript implements EveryFrameScript {

   private boolean isPaused = false;
   private long systemTime;
   private HashMap intervalMap = new HashMap();


   public UNGP_UITimeScript() {
      this.reset();
   }

   public static UNGP_UITimeScript getInstance() {
      Iterator script = Global.getSector().getTransientScripts().iterator();

      EveryFrameScript transientScript;
      do {
         if(!script.hasNext()) {
            UNGP_UITimeScript script1 = new UNGP_UITimeScript();
            Global.getSector().addTransientScript(script1);
            return script1;
         }

         transientScript = (EveryFrameScript)script.next();
      } while(!(transientScript instanceof UNGP_UITimeScript));

      return (UNGP_UITimeScript)transientScript;
   }

   public boolean isDone() {
      return false;
   }

   public boolean runWhilePaused() {
      return true;
   }

   public void advance(float amount) {
      if(!this.isPaused) {
         if(!this.intervalMap.isEmpty()) {
            long curSystemTime = System.nanoTime();
            long diff = curSystemTime - this.systemTime;
            float deltaTime = Math.min((float)diff / 1.0E9F, 1.0F);
            Iterator var7 = this.intervalMap.values().iterator();

            while(var7.hasNext()) {
               IntervalUtil interval = (IntervalUtil)var7.next();
               if(deltaTime < interval.getIntervalDuration()) {
                  interval.advance(deltaTime);
               }
            }

            this.systemTime = curSystemTime;
         }
      }
   }

   public void setPaused(boolean paused) {
      this.isPaused = paused;
      this.reset();
   }

   public static float getFactor(String intervalID) {
      IntervalUtil intervalUtil = (IntervalUtil)getInstance().intervalMap.get(intervalID);
      return intervalUtil != null?Math.min(intervalUtil.getElapsed() / intervalUtil.getIntervalDuration(), 1.0F):0.0F;
   }

   public void reset() {
      this.systemTime = System.nanoTime();
   }

   public static void addInterval(String id, IntervalUtil interval) {
      UNGP_UITimeScript script = getInstance();
      script.intervalMap.put(id, interval);
      script.reset();
   }

   public static void removeInterval(String id) {
      UNGP_UITimeScript script = getInstance();
      script.intervalMap.remove(id);
   }
}
