package ungp.scripts.campaign.everyframe;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignUIAPI;
import com.fs.starfarer.api.campaign.CoreUITabId;
import com.fs.starfarer.api.campaign.listeners.CampaignInputListener;
import com.fs.starfarer.api.campaign.listeners.CampaignUIRenderingListener;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.graphics.SpriteAPI;
import com.fs.starfarer.api.input.InputEventAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.lazywizard.lazylib.FastTrig;
import org.lazywizard.lazylib.MathUtils;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Rectangle;
import ungp.scripts.campaign.UNGP_Settings;
import ungp.scripts.campaign.specialist.UNGP_SpecialistManager;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings.Difficulty;
import ungp.scripts.campaign.specialist.intel.UNGP_SpecialistIntel;
import ungp.scripts.campaign.specialist.rules.UNGP_RulesManager;
import ungp.scripts.campaign.specialist.rules.UNGP_RulesManager.UNGP_RuleSorter;
import ungp.scripts.campaign.specialist.rules.UNGP_RulesManager.URule;
import ungp.scripts.utils.UNGP_Progress;

public class UNGP_SpecialistWidgetPlugin implements EveryFrameScript, CampaignUIRenderingListener, CampaignInputListener {

   private static final float BASIC_ICON_ALPHA = 0.4F;
   private static final float SMALL_ICON_SIZE = 32.0F;
   private static final Rectangle WIDGET_RECT = new Rectangle(10, (int)Global.getSettings().getScreenHeightPixels() - 120, 80, 80);
   private UNGP_Progress moveOverAndWaitProgress = new UNGP_Progress(0.2F);
   private SpriteAPI layer0 = Global.getSettings().getSprite("fx", "UNGP_specialist_icon_layer0");
   private SpriteAPI layer1 = Global.getSettings().getSprite("fx", "UNGP_specialist_icon_layer1");
   private float targetIconAlphaMult = 0.0F;
   private float currentIconAlphaMult = 0.0F;
   private float elapsed = 0.0F;
   private boolean enabled = true;


   public boolean isDone() {
      return false;
   }

   public boolean runWhilePaused() {
      return true;
   }

   public UNGP_SpecialistWidgetPlugin() {
      Global.getSector().getListenerManager().addListener(this, true);
      updateUI();
   }

   public static void updateUI() {
      List transientScripts = Global.getSector().getTransientScripts();
      Iterator var1 = transientScripts.iterator();

      while(var1.hasNext()) {
         EveryFrameScript script = (EveryFrameScript)var1.next();
         if(script instanceof UNGP_SpecialistWidgetPlugin) {
            ((UNGP_SpecialistWidgetPlugin)script).enabled = UNGP_Settings.isLeftTopSpecialistWidgetShown();
            break;
         }
      }

   }

   public static boolean inWidgetRect(int x, int y) {
      return WIDGET_RECT.contains(x, y);
   }

   public void advance(float amount) {
      if(this.enabled) {
         if(UNGP_SpecialistManager.isSpecialistMode()) {
            if(!Global.getSector().isFastForwardIteration()) {
               if(!Global.getSector().isPaused()) {
                  this.elapsed += amount;
                  this.targetIconAlphaMult = 0.4F;
                  if(inWidgetRect(Mouse.getX(), Mouse.getY())) {
                     this.targetIconAlphaMult = 0.4F + this.moveOverAndWaitProgress.getProgress() * 0.6F;
                     this.moveOverAndWaitProgress.advance(amount);
                  } else {
                     this.moveOverAndWaitProgress.reset();
                  }

                  this.targetIconAlphaMult = Math.min(1.0F, Math.max(0.0F, this.targetIconAlphaMult));
                  this.currentIconAlphaMult = Misc.interpolate(this.currentIconAlphaMult, this.targetIconAlphaMult, 5.0F * amount);
               }
            }
         }
      }
   }

   private void renderIcons(List bonusRules, float y) {
      for(int i = 0; i < bonusRules.size(); ++i) {
         float x = (float)WIDGET_RECT.getX() + (float)i * 35.0F;
         SpriteAPI icon = Global.getSettings().getSprite(((URule)bonusRules.get(i)).getSpritePath());
         icon.setSize(32.0F, 32.0F);
         icon.setAlphaMult(0.7F);
         icon.render(x, y);
      }

   }

   public int getListenerInputPriority() {
      return 1000;
   }

   public void processCampaignInputPreCore(List events) {
   }

   public void processCampaignInputPreFleetControl(List events) {
      if(UNGP_SpecialistManager.isSpecialistMode()) {
         Iterator var2 = events.iterator();

         while(var2.hasNext()) {
            InputEventAPI event = (InputEventAPI)var2.next();
            if(!event.isConsumed() && event.isLMBDownEvent() && inWidgetRect(event.getX(), event.getY())) {
               Global.getSector().getCampaignUI().showCoreUITab(CoreUITabId.INTEL, UNGP_SpecialistIntel.getInstance());
               Global.getSoundPlayer().playUISound("ui_button_pressed", 1.0F, 1.0F);
               event.consume();
               break;
            }
         }
      }

   }

   public void processCampaignInputPostCore(List events) {
   }

   public void renderInUICoordsBelowUI(ViewportAPI viewport) {
   }

   public void renderInUICoordsAboveUIBelowTooltips(ViewportAPI viewport) {
   }

   public void renderInUICoordsAboveUIAndTooltips(ViewportAPI viewport) {
      if(this.enabled) {
         if(UNGP_SpecialistManager.isSpecialistMode()) {
            CampaignUIAPI campaignUI = Global.getSector().getCampaignUI();
            if(!campaignUI.isShowingDialog() && !campaignUI.isShowingMenu() && campaignUI.getCurrentCoreTab() == null) {
               Difficulty difficulty = UNGP_RulesManager.getGlobalDifficulty();
               float alphaMult = viewport.getAlphaMult();
               GL11.glBlendFunc(770, 771);
               float iconCenterX = (float)WIDGET_RECT.getX() + (float)WIDGET_RECT.getWidth() / 2.0F;
               float iconCenterY = (float)WIDGET_RECT.getY() + (float)WIDGET_RECT.getHeight() / 2.0F;
               float size = (float)(110.0D * (1.0D + 0.10000000149011612D * FastTrig.sin((double)this.elapsed)));
               this.layer0.setAngle(MathUtils.clampAngle(this.elapsed * 60.0F));
               this.layer0.setAlphaMult(this.currentIconAlphaMult * alphaMult);
               this.layer0.setWidth(size);
               this.layer0.setHeight(size);
               this.layer0.setAdditiveBlend();
               this.layer0.renderAtCenter(iconCenterX, iconCenterY);
               size = (float)(128.0D * (1.0D + 0.10000000149011612D * FastTrig.cos((double)this.elapsed)));
               this.layer1.setAngle(MathUtils.clampAngle(-this.elapsed * 30.0F));
               this.layer1.setAlphaMult(this.currentIconAlphaMult * 0.6F * alphaMult);
               this.layer1.setWidth(size);
               this.layer1.setHeight(size);
               this.layer1.setColor(difficulty.color);
               this.layer1.setAdditiveBlend();
               this.layer1.renderAtCenter(iconCenterX, iconCenterY);
               this.layer1.setColor(Color.white);
               this.layer1.setAngle(MathUtils.clampAngle(this.elapsed * 30.0F));
               this.layer1.setSize(size * 1.5F, size * 1.5F);
               this.layer1.setAlphaMult(this.currentIconAlphaMult * 0.4F * alphaMult);
               this.layer1.renderAtCenter(iconCenterX, iconCenterY);
               size = 64.0F;
               SpriteAPI character = Global.getSettings().getSprite(difficulty.spritePath);
               character.setSize(size, size);
               character.setAlphaMult((float)(0.800000011920929D + 0.20000000298023224D * FastTrig.cos((double)(this.elapsed + 233.0F))) * alphaMult);
               character.renderAtCenter(iconCenterX, iconCenterY);
               if(inWidgetRect(Mouse.getX(), Mouse.getY()) && this.moveOverAndWaitProgress.getProgress() > 0.7F) {
                  ArrayList bonusRules = new ArrayList();
                  ArrayList notBonusRules = new ArrayList();
                  Iterator iconGroup_y = UNGP_RulesManager.ACTIVATED_RULES_IN_THIS_GAME.iterator();

                  while(iconGroup_y.hasNext()) {
                     URule rule = (URule)iconGroup_y.next();
                     if(rule.isPositive()) {
                        bonusRules.add(rule);
                     } else {
                        notBonusRules.add(rule);
                     }
                  }

                  Collections.sort(bonusRules, new UNGP_RuleSorter());
                  Collections.sort(notBonusRules, new UNGP_RuleSorter());
                  float iconGroup_y1 = (float)WIDGET_RECT.getY() - 5.0F - 32.0F;
                  this.renderIcons(bonusRules, iconGroup_y1);
                  iconGroup_y1 -= 37.0F;
                  this.renderIcons(notBonusRules, iconGroup_y1);
               }

            }
         }
      }
   }

}
