package ungp.scripts.campaign.everyframe;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.Script;
import com.fs.starfarer.api.campaign.BuffManagerAPI;
import com.fs.starfarer.api.campaign.CampaignClockAPI;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.SectorAPI;
import com.fs.starfarer.api.campaign.BuffManagerAPI.Buff;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import java.util.Iterator;
import java.util.List;
import org.lwjgl.input.Keyboard;
import ungp.api.rules.tags.UNGP_CampaignTag;
import ungp.api.rules.tags.UNGP_PlayerFleetMemberTag;
import ungp.api.rules.tags.UNGP_PlayerFleetTag;
import ungp.scripts.campaign.UNGP_InGameData;
import ungp.scripts.campaign.UNGP_Settings;
import ungp.scripts.campaign.specialist.UNGP_PlayerFleetMemberBuff;
import ungp.scripts.campaign.specialist.UNGP_SpecialistManager;
import ungp.scripts.campaign.specialist.rules.UNGP_RulesManager;
import ungp.scripts.campaign.ui.UNGP_InteractionDialog;
import ungp.scripts.utils.Constants;

public class UNGP_CampaignPlugin implements EveryFrameScript {

   private static final String KEY = "UNGP_cam";
   private static final float BASE_BUFF_DURATION = 0.1F;
   private UNGP_InGameData inGameData = new UNGP_InGameData();
   private IntervalUtil inheritChecker = new IntervalUtil(1.0F, 1.0F);
   private int oneDayChecker = -1;
   private int oneYearChecker = -1;
   private int oneMonthChecker = -1;
   private float newGameCheckDays = 0.1F;
   private boolean newGameChecked = false;
   private boolean shouldShowDialog = false;


   public static UNGP_CampaignPlugin getInstance() {
      UNGP_CampaignPlugin plugin = (UNGP_CampaignPlugin)Global.getSector().getPersistentData().get("UNGP_cam");
      if(plugin != null) {
         return plugin;
      } else {
         throw new RuntimeException("Something wrong with UNGP, you may best reboot your game...");
      }
   }

   public UNGP_CampaignPlugin() {
      Global.getSector().getPersistentData().put("UNGP_cam", this);
      CampaignClockAPI clock = Global.getSector().getClock();
      this.oneDayChecker = clock.getDay();
      this.oneMonthChecker = clock.getMonth();
      this.oneYearChecker = clock.getCycle();
   }

   public boolean isDone() {
      return false;
   }

   public boolean runWhilePaused() {
      return true;
   }

   public void advance(float amount) {
      if(UNGP_RulesManager.isCacheNeedUpdate()) {
         UNGP_RulesManager.updateRulesCache();
      }

      boolean isPaused = Global.getSector().isPaused();
      SectorAPI sector = Global.getSector();
      CampaignClockAPI clock = sector.getClock();
      if(!isPaused && !this.inGameData.isPassedInheritTime()) {
         float currentDay = clock.convertToDays(amount);
         if(!this.newGameChecked) {
            if(this.newGameCheckDays > 0.0F) {
               this.newGameCheckDays -= currentDay;
            } else {
               this.newGameChecked = true;
               sector.getCampaignUI().showConfirmDialog(Constants.root_i18n.get("gameStartMessage"), Constants.root_i18n.get("confirm"), Constants.root_i18n.get("cancel"), new Script() {
                  public void run() {
                     UNGP_CampaignPlugin.this.shouldShowDialog = true;
                  }
               }, (Script)null);
            }
         }

         this.inheritChecker.advance(currentDay);
         if(this.inheritChecker.intervalElapsed()) {
            this.inGameData.setPassedInheritTime(true);
         }
      }

      if(!sector.getCampaignUI().isShowingDialog()) {
         if(Keyboard.isKeyDown(UNGP_Settings.getShowMenuKey1()) && Keyboard.isKeyDown(UNGP_Settings.getShowMenuKey2())) {
            this.shouldShowDialog = true;
         }

         if(this.shouldShowDialog && this.showUNGPDialog()) {
            this.shouldShowDialog = false;
         }
      }

      if(UNGP_SpecialistManager.isSpecialistMode()) {
         int var19 = clock.getDay();
         int currentYear = clock.getCycle();
         int currentMonth = clock.getMonth();
         UNGP_CampaignPlugin.TempCampaignParams params = new UNGP_CampaignPlugin.TempCampaignParams();
         if(var19 != this.oneDayChecker) {
            this.oneDayChecker = var19;
            params.oneDayPassed = true;
            if(Global.getSettings().isDevMode()) {
               for(int playerFleet = 0; playerFleet < 10; ++playerFleet) {
                  this.inGameData.addTimesToChangeSpecialistMode();
               }
            }
         }

         if(currentMonth != this.oneMonthChecker) {
            this.oneMonthChecker = currentMonth;
            params.oneMonthPassed = true;
         }

         if(currentYear != this.oneYearChecker) {
            this.oneYearChecker = currentYear;
            params.oneYearPassed = true;
            this.inGameData.addTimesToChangeSpecialistMode();
         }

         if(isPaused) {
            amount = 0.0F;
         }

         Iterator var20 = UNGP_RulesManager.CAMPAIGN_TAGS_ITG.iterator();

         while(var20.hasNext()) {
            UNGP_CampaignTag needsSync = (UNGP_CampaignTag)var20.next();
            needsSync.advanceInCampaign(amount, params);
         }

         CampaignFleetAPI var21 = sector.getPlayerFleet();
         if(var21 != null) {
            Iterator var22 = UNGP_RulesManager.PLAYER_FLEET_TAGS_ITG.iterator();

            while(var22.hasNext()) {
               UNGP_PlayerFleetTag members = (UNGP_PlayerFleetTag)var22.next();
               members.applyPlayerFleetStats(var21);
            }

            if(!UNGP_RulesManager.PLAYER_FLEET_MEMBER_TAGS_ITG.isEmpty()) {
               boolean var23 = false;
               List var24 = var21.getFleetData().getMembersListCopy();
               Iterator var12 = var24.iterator();

               while(var12.hasNext()) {
                  FleetMemberAPI member = (FleetMemberAPI)var12.next();
                  BuffManagerAPI buffManager = member.getBuffManager();
                  Iterator var15 = UNGP_RulesManager.PLAYER_FLEET_MEMBER_TAGS_ITG.iterator();

                  while(var15.hasNext()) {
                     UNGP_PlayerFleetMemberTag tag = (UNGP_PlayerFleetMemberTag)var15.next();
                     if(tag.canApply(member)) {
                        Buff test = buffManager.getBuff(tag.getBuffID());
                        if(test instanceof UNGP_PlayerFleetMemberBuff) {
                           UNGP_PlayerFleetMemberBuff buff = (UNGP_PlayerFleetMemberBuff)test;
                           buff.setDur(0.1F);
                           buff.setTag(tag);
                        } else {
                           buffManager.addBuff(new UNGP_PlayerFleetMemberBuff(tag, 0.1F));
                           var23 = true;
                        }
                     }
                  }
               }

               if(var23 || UNGP_PlayerFleetMemberBuff.isShouldForceSyncNextStep()) {
                  var21.forceSync();
                  UNGP_PlayerFleetMemberBuff.completeForceSync();
               }
            }

         }
      }
   }

   public boolean showUNGPDialog() {
      this.newGameChecked = true;
      return Global.getSector().getCampaignUI().showInteractionDialog(new UNGP_InteractionDialog(this.inGameData), Global.getSector().getPlayerFleet());
   }

   public UNGP_InGameData getInGameData() {
      return this.inGameData;
   }

   public static class TempCampaignParams {

      private boolean oneDayPassed = false;
      private boolean oneMonthPassed = false;
      private boolean oneYearPassed = false;


      public boolean isOneYearPassed() {
         return this.oneYearPassed;
      }

      public boolean isOneMonthPassed() {
         return this.oneMonthPassed;
      }

      public boolean isOneDayPassed() {
         return this.oneDayPassed;
      }
   }
}
