package ungp.scripts.campaign.background;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.graphics.SpriteAPI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import ungp.api.backgrounds.UNGP_BackgroundPluginAPI;
import ungp.impl.backgrounds.UNGP_Nothing;
import ungp.scripts.campaign.background.UNGP_Background;
import ungp.scripts.utils.UNGPUtils;

public class UNGP_BackgroundManager {

   public static final String MEM_PLAYER_BACKGROUND_KEY = "$UNGP_player_background";
   private static final String FILE_PATH = "data/campaign/UNGP_backgrounds.csv";
   private static final Map BACKGROUND_MAP = new HashMap();
   private static UNGP_Background DEFAULT_BACKGROUND;


   public static void loadAllBackgrounds() {
      ClassLoader classLoader = Global.getSettings().getScriptClassLoader();

      try {
         JSONArray e = Global.getSettings().getMergedSpreadsheetDataForMod("id", "data/campaign/UNGP_backgrounds.csv", "ungp");
         int i = 0;

         for(int len = e.length(); i < len; ++i) {
            JSONObject row = e.getJSONObject(i);
            String id = row.optString("id", "[EMPTY]");
            if(!UNGPUtils.isEmpty(id)) {
               String name = row.optString("name", "[EMPTY]");
               float order = (float)row.optDouble("order", 10000.0D);
               String shortDesc = row.optString("short", "[EMPTY]");
               String desc = row.optString("desc", "[EMPTY]");
               if(UNGPUtils.isEmpty(desc)) {
                  desc = shortDesc;
               }

               String spritePath = row.optString("spritePath", "[EMPTY]");
               String extra1 = row.optString("extra1", "[EMPTY]");
               String extra2 = row.optString("extra2", "[EMPTY]");
               String source = row.optString("source", "[EMPTY]");
               String effectPluginName = row.getString("effectPlugin");
               String tags = row.optString("tags", "[EMPTY]");
               ArrayList tagList = new ArrayList();
               String[] backgroundPlugin;
               if(!UNGPUtils.isEmpty(tags)) {
                  backgroundPlugin = tags.split(",");
                  String[] sprite = backgroundPlugin;
                  int background = backgroundPlugin.length;

                  for(int var20 = 0; var20 < background; ++var20) {
                     String s = sprite[var20];
                     tagList.add(s.trim());
                  }
               }

               backgroundPlugin = null;
               Object var23;
               if(!UNGPUtils.isEmpty(effectPluginName)) {
                  Class var24 = classLoader.loadClass(effectPluginName);
                  var23 = (UNGP_BackgroundPluginAPI)var24.newInstance();
               } else {
                  var23 = new UNGP_Nothing();
               }

               if(UNGPUtils.isEmpty(spritePath)) {
                  spritePath = "graphics/portraits/portrait_generic.png";
               }

               SpriteAPI var25 = Global.getSettings().getSprite(spritePath);
               if(var25 == null || var25.getHeight() < 1.0F) {
                  Global.getSettings().loadTexture(spritePath);
               }

               UNGP_Background var26 = new UNGP_Background(id, order, name, shortDesc, desc, spritePath, source, extra1, extra2, tagList, (UNGP_BackgroundPluginAPI)var23);
               BACKGROUND_MAP.put(id, var26);
               if(id.contentEquals("nothing")) {
                  DEFAULT_BACKGROUND = var26;
               }
            }
         }
      } catch (Exception var22) {
         Global.getLogger(UNGP_BackgroundManager.class).error(var22);
         throw new RuntimeException("Failed to load UNGP backgrounds:", var22);
      }

      if(DEFAULT_BACKGROUND == null) {
         throw new RuntimeException("Failed to find default UNGP background: nothing");
      }
   }

   public static List getSortedBackgroundsCopy() {
      ArrayList backgrounds = new ArrayList(BACKGROUND_MAP.values());
      Collections.sort(backgrounds, new Comparator() {
         public int compare(UNGP_Background o1, UNGP_Background o2) {
            return Float.compare(o1.getOrder(), o2.getOrder());
         }
      });
      return backgrounds;
   }

   public static UNGP_Background getDefaultBackground() {
      return DEFAULT_BACKGROUND;
   }

   public static UNGP_Background getPlayerBackground() {
      MemoryAPI memoryWithoutUpdate = Global.getSector().getCharacterData().getMemoryWithoutUpdate();
      return memoryWithoutUpdate.contains("$UNGP_player_background")?(UNGP_Background)BACKGROUND_MAP.get(memoryWithoutUpdate.getString("$UNGP_player_background")):DEFAULT_BACKGROUND;
   }

   public static void setPlayerBackground(UNGP_Background background) {
      Global.getSector().getCharacterData().getMemoryWithoutUpdate().set("$UNGP_player_background", background.getId());
   }

}
