package ungp.scripts.campaign.ability;

import com.fs.starfarer.api.impl.campaign.abilities.BaseDurationAbility;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import org.lwjgl.input.Keyboard;
import ungp.scripts.campaign.UNGP_Settings;
import ungp.scripts.campaign.everyframe.UNGP_CampaignPlugin;
import ungp.scripts.utils.Constants;

public class UNGP_CheckSavepointAbility extends BaseDurationAbility {

   protected void activateImpl() {
      UNGP_CampaignPlugin.getInstance().showUNGPDialog();
   }

   protected void applyEffect(float amount, float level) {
   }

   protected void deactivateImpl() {
   }

   protected void cleanupImpl() {
   }

   public void createTooltip(TooltipMakerAPI tooltip, boolean expanded) {
      Color gray = Misc.getGrayColor();
      Color highlight = Misc.getHighlightColor();
      LabelAPI title = tooltip.addTitle(Constants.ability_i18n.get("checkSavepoint_title"));
      title.setHighlightColor(gray);
      float pad = 10.0F;
      tooltip.addPara(Constants.ability_i18n.get("checkSavepoint_desc"), pad, highlight, new String[]{Keyboard.getKeyName(UNGP_Settings.getShowMenuKey1()), Keyboard.getKeyName(UNGP_Settings.getShowMenuKey2())});
   }

   public boolean hasTooltip() {
      return true;
   }
}
