package ungp.impl.rules.other;

import com.fs.starfarer.api.impl.campaign.intel.MessageIntel;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.Iterator;
import java.util.List;
import ungp.api.rules.UNGP_BaseRuleEffect;
import ungp.api.rules.tags.UNGP_TweakBeforeApplyTag;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings.Difficulty;
import ungp.scripts.campaign.specialist.rules.UNGP_RulesManager;
import ungp.scripts.campaign.specialist.rules.UNGP_RulesManager.URule;

public class UNGP_Yang extends UNGP_BaseRuleEffect implements UNGP_TweakBeforeApplyTag {

   public float getValueByDifficulty(int index, Difficulty difficulty) {
      return 0.0F;
   }

   public String getDescriptionParams(int index, Difficulty difficulty) {
      return index == 0?UNGP_RulesManager.getPNRuleString(true):(index == 1?UNGP_RulesManager.getPNRuleString(false):null);
   }

   public void tweakBeforeApply(List activeRules, List originalActiveRules) {
      boolean containsYing = false;
      Iterator picker = originalActiveRules.iterator();

      while(picker.hasNext()) {
         URule rulesToPick = (URule)picker.next();
         if(rulesToPick.getId().contentEquals("ying")) {
            containsYing = true;
         }
      }

      WeightedRandomPicker picker1 = new WeightedRandomPicker(this.getRandom());
      List rulesToPick1 = UNGP_RulesManager.getAllRulesCopy();
      rulesToPick1.removeAll(originalActiveRules);
      rulesToPick1.removeAll(activeRules);
      Iterator rolled = rulesToPick1.iterator();

      while(rolled.hasNext()) {
         URule intel = (URule)rolled.next();
         if(intel != this.rule && intel.isRollable()) {
            if(containsYing) {
               picker1.add(intel);
            } else if(intel.isPositive()) {
               picker1.add(intel);
            }
         }
      }

      if(!picker1.isEmpty()) {
         URule rolled1 = (URule)picker1.pick();
         activeRules.add(rolled1);
         MessageIntel intel1 = this.createMessage();
         intel1.setIcon(rolled1.getSpritePath());
         intel1.addLine(this.rule.getExtra1(), Misc.getTextColor(), new String[]{rolled1.getName()}, new Color[]{rolled1.getCorrectColor()});
         this.showMessage(intel1);
      }

      activeRules.remove(this.rule);
   }
}
