package ungp.impl.rules.other;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.Iterator;
import ungp.api.rules.UNGP_BaseRuleEffect;
import ungp.api.rules.tags.UNGP_CampaignTag;
import ungp.scripts.campaign.everyframe.UNGP_CampaignPlugin.TempCampaignParams;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings.Difficulty;
import ungp.scripts.campaign.specialist.intel.UNGP_SpecialistIntel.RuleMessage;

public class UNGP_WorkHard extends UNGP_BaseRuleEffect implements UNGP_CampaignTag {

   private static final String MEM_CHECK_WORK = "$UNGP_WorkHard_Warning";
   private static final float STRIKE_CHANCE_PER_DAY = 0.08F;
   private static final float CR_LOSS = 0.75F;
   private static final float CREW_LOSS = 0.5F;
   private float ratio;


   public void updateDifficultyCache(Difficulty difficulty) {
      this.ratio = this.getValueByDifficulty(0, difficulty);
   }

   public float getValueByDifficulty(int index, Difficulty difficulty) {
      return index == 0?difficulty.getLinearValue(0.15F, 0.15F):0.0F;
   }

   public void advanceInCampaign(float amount, TempCampaignParams params) {
      if(params.isOneDayPassed()) {
         CampaignFleetAPI fleet = Global.getSector().getPlayerFleet();
         float crew = (float)fleet.getCargo().getCrew();
         crew = crew < 1.0F?1.0F:crew;
         float marine = (float)fleet.getCargo().getMarines();
         float neededMarine = (float)Math.ceil((double)(crew * this.ratio - marine));
         if(neededMarine > 0.0F) {
            WeightedRandomPicker picker;
            Color deadCrew;
            if(!fleet.getMemoryWithoutUpdate().contains("$UNGP_WorkHard_Warning")) {
               fleet.getMemoryWithoutUpdate().set("$UNGP_WorkHard_Warning", Boolean.valueOf(true), 3.0F);
               picker = (int)neededMarine;
               Color notWorkHard = Misc.getNegativeHighlightColor();
               deadCrew = Misc.getHighlightColor();
               Global.getSector().getCampaignUI().addMessage(String.format(this.rule.getExtra2(), new Object[]{picker}), notWorkHard, picker, "", deadCrew, deadCrew);
            }

            if(Math.random() < 0.07999999821186066D) {
               picker = new WeightedRandomPicker();
               Iterator notWorkHard1 = fleet.getFleetData().getMembersListCopy().iterator();

               while(notWorkHard1.hasNext()) {
                  FleetMemberAPI deadCrew1 = (FleetMemberAPI)notWorkHard1.next();
                  if(!deadCrew1.isMothballed()) {
                     picker.add(deadCrew1, deadCrew1.getRepairTracker().getCR());
                  }
               }

               FleetMemberAPI notWorkHard2 = (FleetMemberAPI)picker.pickAndRemove();

               int deadCrew2;
               for(deadCrew2 = notWorkHard2.getCrewComposition().getCrewInt(); deadCrew2 < 1; deadCrew2 = notWorkHard2.getCrewComposition().getCrewInt()) {
                  if(picker.isEmpty()) {
                     return;
                  }

                  notWorkHard2 = (FleetMemberAPI)picker.pickAndRemove();
               }

               deadCrew = Math.max(1, (int)((float)deadCrew2 * 0.5F));
               if(crew - (float)deadCrew <= 0.0F) {
                  return;
               }

               notWorkHard2.getRepairTracker().applyCREvent(-0.75F, this.rule.getName());
               fleet.getCargo().removeCrew((int)deadCrew);
               RuleMessage message = new RuleMessage(this.rule, this.rule.getExtra1(), new String[]{notWorkHard2.getShipName(), deadCrew});
               message.send();
            }
         }
      }

   }

   public String getDescriptionParams(int index, Difficulty difficulty) {
      return index == 0?this.getPercentString(this.getValueByDifficulty(index, difficulty) * 100.0F):(index == 1?"8%":(index == 2?"75%":(index == 3?"50%":null)));
   }
}
