package ungp.impl.rules.other;

import com.fs.starfarer.api.impl.campaign.intel.MessageIntel;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import ungp.api.rules.UNGP_BaseRuleEffect;
import ungp.api.rules.tags.UNGP_CampaignTag;
import ungp.scripts.campaign.UNGP_InGameData;
import ungp.scripts.campaign.everyframe.UNGP_CampaignPlugin.TempCampaignParams;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings.Difficulty;
import ungp.scripts.campaign.specialist.rules.UNGP_RulesManager;
import ungp.scripts.campaign.specialist.rules.UNGP_RulesManager.URule;

public class UNGP_StillGrowingUp extends UNGP_BaseRuleEffect implements UNGP_CampaignTag {

   public void updateDifficultyCache(Difficulty difficulty) {
      int[] monthData = (int[])this.getDataInCampaign(0);
      if(monthData == null) {
         monthData = new int[]{0, 3};
         this.saveDataInCampaign(0, monthData);
      }

   }

   public float getValueByDifficulty(int index, Difficulty difficulty) {
      return 0.0F;
   }

   public String getDescriptionParams(int index, Difficulty difficulty) {
      return index != 0 && index != 1?super.getDescriptionParams(index, difficulty):"3";
   }

   public void advanceInCampaign(float amount, TempCampaignParams params) {
      if(params.isOneMonthPassed()) {
         int[] monthData = (int[])this.getDataInCampaign(0);
         if(monthData == null) {
            monthData = new int[]{0, 3};
         }

         int elapsedMonth = monthData[0] + 1;
         int maxMonth = monthData[1];
         if(elapsedMonth >= maxMonth) {
            UNGP_InGameData intel = UNGP_InGameData.getDataInSave();
            List activatedRules = intel.getActivatedRules();
            List allRules = UNGP_RulesManager.getAllRulesCopy();
            WeightedRandomPicker picker = new WeightedRandomPicker(this.getRandom());
            Object addedRuleIDs = (Set)this.getDataInCampaign(1);
            if(addedRuleIDs == null) {
               addedRuleIDs = new HashSet();
               this.saveDataInCampaign(1, addedRuleIDs);
            }

            Iterator toAdd = allRules.iterator();

            while(toAdd.hasNext()) {
               URule intel1 = (URule)toAdd.next();
               if(intel1.isPositive() && !activatedRules.contains(intel1) && !intel1.isGolden() && !intel1.isMilestone() && intel1.isRollable()) {
                  int weight;
                  if(((Set)addedRuleIDs).contains(intel1.getId())) {
                     weight = 1;
                  } else {
                     weight = Math.min(6 - Math.abs(intel1.getCost()), 1);
                  }

                  picker.add(intel1, (float)weight);
               }
            }

            URule toAdd1 = (URule)picker.pick();
            if(toAdd1 != null) {
               activatedRules.add(toAdd1);
               ((Set)addedRuleIDs).add(toAdd1.getId());
               MessageIntel intel3 = new MessageIntel(this.rule.getName(), toAdd1.getCorrectColor());
               intel3.setIcon(toAdd1.getSpritePath());
               intel3.addLine(this.rule.getExtra1(), Misc.getTextColor(), new String[]{toAdd1.getName()}, new Color[]{toAdd1.getCorrectColor()});
               intel3.setSound("UNGP_still_growing_up_activate");
               this.showMessage(intel3);
            }

            intel.saveActivatedRules(activatedRules);
            UNGP_RulesManager.updateCacheNextFrame();
            monthData[0] = 0;
            monthData[1] += 3;
         } else {
            monthData[0] = elapsedMonth;
         }

         MessageIntel intel2 = this.createMessage();
         intel2.setIcon(this.rule.getSpritePath());
         intel2.addLine(this.rule.getExtra2(), Misc.getTextColor(), new String[]{monthData[1] - monthData[0]}, new Color[]{Misc.getHighlightColor()});
         this.showMessage(intel2);
         this.saveDataInCampaign(0, monthData);
      }

   }

   public boolean addIntelTips(TooltipMakerAPI imageTooltip) {
      int[] monthData = (int[])this.getDataInCampaign(0);
      if(monthData != null) {
         imageTooltip.addPara(this.rule.getExtra2(), 0.0F, Misc.getHighlightColor(), new String[]{monthData[1] - monthData[0]});
         return true;
      } else {
         return false;
      }
   }
}
