package ungp.impl.rules.other;

import com.fs.starfarer.api.impl.campaign.intel.MessageIntel;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.Iterator;
import java.util.List;
import ungp.api.rules.UNGP_BaseRuleEffect;
import ungp.api.rules.tags.UNGP_TweakBeforeApplyTag;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings.Difficulty;
import ungp.scripts.campaign.specialist.rules.UNGP_RulesManager;
import ungp.scripts.campaign.specialist.rules.UNGP_RulesManager.URule;
import ungp.scripts.campaign.specialist.rules.UNGP_RulesManager.URule.Tags;

public class UNGP_RainPour extends UNGP_BaseRuleEffect implements UNGP_TweakBeforeApplyTag {

   public float getValueByDifficulty(int index, Difficulty difficulty) {
      return 0.0F;
   }

   public String getDescriptionParams(int index, Difficulty difficulty) {
      return index == 0?"2":(index == 1?UNGP_RulesManager.getPNRuleString(false):null);
   }

   public void tweakBeforeApply(List activeRules, List originalActiveRules) {
      WeightedRandomPicker picker = new WeightedRandomPicker(this.getRandom());
      List rulesToPick = UNGP_RulesManager.getAllRulesCopy();
      rulesToPick.removeAll(originalActiveRules);
      Iterator i = rulesToPick.iterator();

      URule rolled;
      while(i.hasNext()) {
         rolled = (URule)i.next();
         if(rolled != this.rule && !rolled.hasTag(Tags.NO_ROLL) && !rolled.isPositive()) {
            picker.add(rolled);
         }
      }

      if(!picker.isEmpty()) {
         for(int var8 = 0; var8 < 2; ++var8) {
            rolled = (URule)picker.pickAndRemove();
            activeRules.add(rolled);
            MessageIntel intel = this.createMessage();
            intel.setIcon(rolled.getSpritePath());
            intel.addLine(this.rule.getExtra1(), Misc.getTextColor(), new String[]{rolled.getName()}, new Color[]{rolled.getCorrectColor()});
            this.showMessage(intel);
         }
      }

      activeRules.remove(this.rule);
   }
}
