package ungp.impl.rules.other;

import ungp.api.rules.UNGP_BaseRuleEffect;
import ungp.scripts.campaign.UNGP_InGameData;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings.Difficulty;

public class UNGP_NoWayBack extends UNGP_BaseRuleEffect {

   private float timeMultiplier;


   public void updateDifficultyCache(Difficulty difficulty) {
      this.timeMultiplier = this.getValueByDifficulty(0, difficulty);
   }

   public float getValueByDifficulty(int index, Difficulty difficulty) {
      return index == 0?difficulty.getLinearValue(0.25F, -0.15F):0.0F;
   }

   public String getDescriptionParams(int index, Difficulty difficulty) {
      return index == 0?this.getFactorString(this.getValueByDifficulty(0, difficulty)):(index == 1?this.getFactorString((float)Math.ceil((double)(1.0F / this.getValueByDifficulty(0, difficulty)))):super.getDescriptionParams(index, difficulty));
   }

   public void applyGlobalStats() {
      UNGP_InGameData.getDataInSave().getChangeTimeStat().modifyMult(this.buffID, this.timeMultiplier);
   }

   public void unapplyGlobalStats() {
      UNGP_InGameData.getDataInSave().getChangeTimeStat().unmodify(this.buffID);
   }
}
