package ungp.impl.rules.other;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.characters.PersonAPI;
import ungp.api.rules.UNGP_BaseRuleEffect;
import ungp.api.rules.tags.UNGP_CampaignTag;
import ungp.scripts.campaign.everyframe.UNGP_CampaignPlugin.TempCampaignParams;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings.Difficulty;
import ungp.scripts.campaign.specialist.intel.UNGP_SpecialistIntel.RuleMessage;

public class UNGP_MonotonousTeller extends UNGP_BaseRuleEffect implements UNGP_CampaignTag {

   private int daysToLostStoryPoint;


   public void updateDifficultyCache(Difficulty difficulty) {
      this.daysToLostStoryPoint = (int)this.getValueByDifficulty(0, difficulty);
   }

   public float getValueByDifficulty(int index, Difficulty difficulty) {
      return (float)Math.round(difficulty.getLinearValue(120.0F, -60.0F));
   }

   public void advanceInCampaign(float amount, TempCampaignParams params) {
      if(params.isOneDayPassed()) {
         Integer sinceLastLost = (Integer)this.getDataInCampaign(0);
         if(sinceLastLost == null) {
            sinceLastLost = Integer.valueOf(0);
         }

         sinceLastLost = Integer.valueOf(sinceLastLost.intValue() + 1);
         if(sinceLastLost.intValue() > this.daysToLostStoryPoint) {
            PersonAPI player = Global.getSector().getPlayerPerson();
            int storyPoints = player.getStats().getStoryPoints();
            if(storyPoints > 0) {
               player.getStats().setStoryPoints(storyPoints - 1);
               sinceLastLost = Integer.valueOf(0);
               RuleMessage message = new RuleMessage(this.rule, this.rule.getExtra1(), new String[]{"1"});
               message.send();
            }
         }

         this.saveDataInCampaign(0, sinceLastLost);
      }

   }

   public String getDescriptionParams(int index, Difficulty difficulty) {
      return index == 0?this.getFactorString(this.getValueByDifficulty(index, difficulty)):(index == 1?"1":null);
   }
}
