package ungp.impl.rules.other;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.impl.campaign.intel.MessageIntel;
import com.fs.starfarer.api.impl.campaign.intel.inspection.HegemonyInspectionIntel;
import com.fs.starfarer.api.impl.campaign.intel.inspection.HegemonyInspectionIntel.AntiInspectionOrders;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import ungp.api.rules.UNGP_BaseRuleEffect;
import ungp.api.rules.tags.UNGP_CampaignTag;
import ungp.scripts.campaign.everyframe.UNGP_CampaignPlugin.TempCampaignParams;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings.Difficulty;

public class UNGP_MakeAnException extends UNGP_BaseRuleEffect implements UNGP_CampaignTag {

   private float rollChance = 0.5F;


   public void updateDifficultyCache(Difficulty difficulty) {
      this.rollChance = this.getValueByDifficulty(0, difficulty);
   }

   public float getValueByDifficulty(int index, Difficulty difficulty) {
      return index == 0?difficulty.getLinearValue(0.5F, 0.5F, 1.0F):0.0F;
   }

   public String getDescriptionParams(int index, Difficulty difficulty) {
      return index == 0?this.getPercentString(this.getValueByDifficulty(index, difficulty) * 100.0F):super.getDescriptionParams(index, difficulty);
   }

   public void advanceInCampaign(float amount, TempCampaignParams params) {
      if(params.isOneDayPassed()) {
         Object checkedHegemonyInspection = (List)this.getDataInCampaign(0);
         if(checkedHegemonyInspection == null) {
            checkedHegemonyInspection = new ArrayList();
            this.saveDataInCampaign(0, checkedHegemonyInspection);
         }

         Iterator iterator = Global.getSector().getIntelManager().getIntel(HegemonyInspectionIntel.class).iterator();

         while(iterator.hasNext()) {
            IntelInfoPlugin next = (IntelInfoPlugin)iterator.next();
            HegemonyInspectionIntel inspectionIntel = (HegemonyInspectionIntel)next;
            if(!((List)checkedHegemonyInspection).contains(inspectionIntel) && !inspectionIntel.isDone() && !inspectionIntel.shouldRemoveIntel()) {
               FactionAPI faction = inspectionIntel.getFaction();
               if(!faction.isHostileTo("player") && inspectionIntel.getOrders() != AntiInspectionOrders.BRIBE && this.roll(this.getRandomByDay(), this.rollChance)) {
                  inspectionIntel.setOrders(AntiInspectionOrders.BRIBE);
                  MessageIntel message = this.createMessage();
                  message.addLine(this.rule.getExtra1());
                  this.showMessage(message);
               }

               ((List)checkedHegemonyInspection).add(inspectionIntel);
            }
         }

         ListIterator iterator1 = ((List)checkedHegemonyInspection).listIterator();

         while(iterator1.hasNext()) {
            HegemonyInspectionIntel next1 = (HegemonyInspectionIntel)iterator1.next();
            if(next1.isDone() || next1.shouldRemoveIntel()) {
               iterator1.remove();
            }
         }
      }

   }

   public void cleanUp() {
      this.clearDataInCampaign(0);
   }
}
