package ungp.impl.rules.other;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import ungp.api.rules.UNGP_BaseRuleEffect;
import ungp.api.rules.tags.UNGP_CampaignTag;
import ungp.scripts.campaign.everyframe.UNGP_CampaignPlugin.TempCampaignParams;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings.Difficulty;

public class UNGP_LobsterPerDay extends UNGP_BaseRuleEffect implements UNGP_CampaignTag {

   public void updateDifficultyCache(Difficulty difficulty) {
   }

   public float getValueByDifficulty(int index, Difficulty difficulty) {
      return 0.0F;
   }

   public void advanceInCampaign(float amount, TempCampaignParams params) {
      if(params.isOneDayPassed()) {
         CampaignFleetAPI fleet = Global.getSector().getPlayerFleet();
         if(fleet != null) {
            CargoAPI cargo = fleet.getCargo();
            if(cargo.getSpaceLeft() - 1.0F > 0.0F) {
               cargo.addCommodity("lobster", 2.0F);
            }
         }
      }

   }

   public String getDescriptionParams(int index, Difficulty difficulty) {
      return index == 0?"2":null;
   }
}
