package ungp.impl.rules.other;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import ungp.api.rules.UNGP_BaseRuleEffect;
import ungp.api.rules.tags.UNGP_CampaignTag;
import ungp.scripts.campaign.everyframe.UNGP_CampaignPlugin.TempCampaignParams;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings.Difficulty;
import ungp.scripts.campaign.specialist.intel.UNGP_SpecialistIntel.RuleMessage;

public class UNGP_Inflation extends UNGP_BaseRuleEffect implements UNGP_CampaignTag {

   private int reducePercent;


   public void updateDifficultyCache(Difficulty difficulty) {
      this.reducePercent = (int)this.getValueByDifficulty(0, difficulty);
   }

   public float getValueByDifficulty(int index, Difficulty difficulty) {
      return (float)Math.round(difficulty.getLinearValue(1.5F, 1.0F));
   }

   public void advanceInCampaign(float amount, TempCampaignParams params) {
      if(params.isOneMonthPassed()) {
         CampaignFleetAPI player = Global.getSector().getPlayerFleet();
         float credits = player.getCargo().getCredits().get();
         Object toReduce = (int)(credits * (float)this.reducePercent * 0.01F);
         if(toReduce > 0) {
            player.getCargo().getCredits().subtract((float)toReduce);
            RuleMessage message = new RuleMessage(this.rule, this.rule.getExtra1(), new String[]{(String)toReduce});
            message.send();
         }
      }

   }

   public String getDescriptionParams(int index, Difficulty difficulty) {
      return index == 0?this.getPercentString(this.getValueByDifficulty(index, difficulty)):null;
   }
}
