package ungp.impl.rules.other;

import com.fs.starfarer.api.impl.campaign.intel.MessageIntel;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import ungp.api.rules.UNGP_BaseRuleEffect;
import ungp.api.rules.tags.UNGP_CampaignTag;
import ungp.scripts.campaign.UNGP_InGameData;
import ungp.scripts.campaign.everyframe.UNGP_CampaignPlugin.TempCampaignParams;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings.Difficulty;
import ungp.scripts.campaign.specialist.rules.UNGP_RulesManager;
import ungp.scripts.campaign.specialist.rules.UNGP_RulesManager.URule;

public class UNGP_EntropiusMind extends UNGP_BaseRuleEffect implements UNGP_CampaignTag {

   public void updateDifficultyCache(Difficulty difficulty) {
      Integer daysPassed = (Integer)this.getDataInCampaign(0);
      if(daysPassed == null) {
         this.saveDataInCampaign(0, Integer.valueOf(0));
      }

   }

   public float getValueByDifficulty(int index, Difficulty difficulty) {
      return 0.0F;
   }

   public void advanceInCampaign(float amount, TempCampaignParams params) {
      if(params.isOneDayPassed()) {
         Integer daysPassed = (Integer)this.getDataInCampaign(0);
         if(daysPassed == null) {
            daysPassed = Integer.valueOf(0);
         }

         daysPassed = Integer.valueOf(daysPassed.intValue() + 1);
         if(daysPassed.intValue() == 7) {
            UNGP_InGameData inGameData = UNGP_InGameData.getDataInSave();
            List allRules = UNGP_RulesManager.getAllRulesCopy();
            ArrayList activatedRules = new ArrayList();
            activatedRules.add(this.rule);
            Random random = this.getRandomByDay();
            WeightedRandomPicker picker = new WeightedRandomPicker(random);
            Iterator rulesToAdd = allRules.iterator();

            while(rulesToAdd.hasNext()) {
               URule message = (URule)rulesToAdd.next();
               if(message != this.rule && message.isRollable()) {
                  picker.add(message);
               }
            }

            int var12 = random.nextInt((int)picker.getTotal());

            for(int var13 = 0; var13 < var12; ++var13) {
               URule toAdd = (URule)picker.pickAndRemove();
               activatedRules.add(toAdd);
            }

            MessageIntel var14 = this.createMessage();
            var14.addLine(this.rule.getExtra1(), Misc.getHighlightColor());
            this.showMessage(var14);
            inGameData.saveActivatedRules(activatedRules);
            UNGP_RulesManager.updateCacheNextFrame();
            daysPassed = Integer.valueOf(0);
         }

         this.saveDataInCampaign(0, daysPassed);
      }

   }

   public String getDescriptionParams(int index, Difficulty difficulty) {
      return null;
   }

   public boolean addIntelTips(TooltipMakerAPI imageTooltip) {
      Integer daysPassed = (Integer)this.getDataInCampaign(0);
      if(daysPassed != null) {
         imageTooltip.addPara(this.rule.getExtra2(), 0.0F, Misc.getHighlightColor(), new String[]{7 - daysPassed.intValue()});
         return true;
      } else {
         return false;
      }
   }
}
