package ungp.impl.rules.other;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignClockAPI;
import com.fs.starfarer.api.impl.campaign.intel.MessageIntel;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.Iterator;
import java.util.List;
import ungp.api.rules.UNGP_BaseRuleEffect;
import ungp.api.rules.tags.UNGP_CampaignTag;
import ungp.scripts.campaign.UNGP_InGameData;
import ungp.scripts.campaign.everyframe.UNGP_CampaignPlugin.TempCampaignParams;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings.Difficulty;
import ungp.scripts.campaign.specialist.rules.UNGP_RulesManager;
import ungp.scripts.campaign.specialist.rules.UNGP_RulesManager.URule;

public class UNGP_BirthdayPresent extends UNGP_BaseRuleEffect implements UNGP_CampaignTag {

   public void updateDifficultyCache(Difficulty difficulty) {
      int[] giftTime = (int[])this.getDataInCampaign(0);
      if(giftTime == null) {
         CampaignClockAPI clock = Global.getSector().getClock();
         giftTime = new int[]{clock.getCycle() + 1, clock.getMonth(), clock.getDay()};
         this.saveDataInCampaign(0, giftTime);
      }

   }

   public float getValueByDifficulty(int index, Difficulty difficulty) {
      return 0.0F;
   }

   public String getDescriptionParams(int index, Difficulty difficulty) {
      return index == 0?"1":super.getDescriptionParams(index, difficulty);
   }

   public void advanceInCampaign(float amount, TempCampaignParams params) {
      if(params.isOneDayPassed()) {
         int[] giftTime = (int[])this.getDataInCampaign(0);
         CampaignClockAPI clock = Global.getSector().getClock();
         if(giftTime != null) {
            if(clock.getCycle() == giftTime[0] && clock.getMonth() == giftTime[1] && clock.getDay() == giftTime[2]) {
               UNGP_InGameData inGameData = UNGP_InGameData.getDataInSave();
               List activatedRules = inGameData.getActivatedRules();
               List allRules = UNGP_RulesManager.getAllRulesCopy();
               WeightedRandomPicker picker = new WeightedRandomPicker(Misc.getRandom((long)(clock.getCycle() + clock.getMonth() + clock.getDay()), inGameData.getCurCycle()));
               Iterator toAdd = allRules.iterator();

               while(toAdd.hasNext()) {
                  URule intel = (URule)toAdd.next();
                  if(intel.isPositive() && !activatedRules.contains(intel) && intel.isRollable()) {
                     picker.add(intel, (float)Math.abs(intel.getCost()));
                  }
               }

               URule toAdd1 = (URule)picker.pick();
               activatedRules.remove(this.rule);
               if(toAdd1 != null) {
                  activatedRules.add(toAdd1);
                  MessageIntel intel1 = this.createMessage();
                  intel1.setIcon(toAdd1.getSpritePath());
                  intel1.addLine(this.rule.getExtra1(), Misc.getTextColor(), new String[]{toAdd1.getName()}, new Color[]{toAdd1.getCorrectColor()});
                  this.showMessage(intel1);
                  Global.getSoundPlayer().playUISound("UNGP_birthdaypresent_activate", 1.0F, 1.0F);
               }

               inGameData.saveActivatedRules(activatedRules);
               UNGP_RulesManager.updateCacheNextFrame();
            }
         } else {
            giftTime = new int[]{clock.getCycle() + 1, clock.getMonth(), clock.getDay()};
            this.saveDataInCampaign(0, giftTime);
         }
      }

   }

   public void cleanUp() {
      this.clearDataInCampaign(0);
   }

   public boolean addIntelTips(TooltipMakerAPI imageTooltip) {
      int[] giftTime = (int[])this.getDataInCampaign(0);
      if(giftTime != null) {
         imageTooltip.addPara(this.rule.getExtra2(), 0.0F, Misc.getHighlightColor(), new String[]{giftTime[0], giftTime[1], giftTime[2]});
         return true;
      } else {
         return false;
      }
   }
}
