package ungp.impl.rules.other;

import com.fs.starfarer.api.impl.campaign.intel.MessageIntel;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.Iterator;
import java.util.List;
import ungp.api.rules.UNGP_BaseRuleEffect;
import ungp.api.rules.tags.UNGP_TweakBeforeApplyTag;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings.Difficulty;
import ungp.scripts.campaign.specialist.rules.UNGP_RulesManager;
import ungp.scripts.campaign.specialist.rules.UNGP_RulesManager.URule;

public class UNGP_Amnesia extends UNGP_BaseRuleEffect implements UNGP_TweakBeforeApplyTag {

   public void tweakBeforeApply(List activeRules, List originalActiveRules) {
      WeightedRandomPicker picker = new WeightedRandomPicker(this.getRandom());
      Iterator rolled = activeRules.iterator();

      while(rolled.hasNext()) {
         URule intel = (URule)rolled.next();
         if(intel.isPositive()) {
            picker.add(intel);
         }
      }

      if(!picker.isEmpty()) {
         URule rolled1 = (URule)picker.pick();
         activeRules.remove(rolled1);
         MessageIntel intel1 = this.createMessage();
         intel1.setIcon(rolled1.getSpritePath());
         intel1.addLine(this.rule.getExtra1(), Misc.getTextColor(), new String[]{rolled1.getName()}, new Color[]{rolled1.getCorrectColor()});
         this.showMessage(intel1);
      }

      activeRules.remove(this.rule);
   }

   public String getDescriptionParams(int index, Difficulty difficulty) {
      return index == 0?UNGP_RulesManager.getPNRuleString(true):super.getDescriptionParams(index, difficulty);
   }
}
