package ungp.impl.rules.member;

import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.DModManager;
import ungp.api.rules.UNGP_MemberBuffRuleEffect;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings.Difficulty;

public class UNGP_WorseForUse extends UNGP_MemberBuffRuleEffect {

   private static final float PENALTY_PER_D_MOD = 5.0F;


   public float getValueByDifficulty(int index, Difficulty difficulty) {
      return index == 0?5.0F:super.getValueByDifficulty(index, difficulty);
   }

   public void applyPlayerFleetMemberInCampaign(FleetMemberAPI member) {
      if(member != null) {
         if(member.getVariant() != null) {
            int numDMods = DModManager.getNumDMods(member.getVariant());
            float penaltyMultiplier = Math.max(0.01F, (100.0F - (float)numDMods * 5.0F) * 0.01F);
            MutableShipStatsAPI stats = member.getStats();
            String id = this.getBuffID();
            stats.getArmorBonus().modifyMult(id, penaltyMultiplier);
            stats.getHullBonus().modifyMult(id, penaltyMultiplier);
            stats.getFluxCapacity().modifyMult(id, penaltyMultiplier);
            stats.getFluxDissipation().modifyMult(id, penaltyMultiplier);
         }
      }
   }

   public String getDescriptionParams(int index, Difficulty difficulty) {
      return index == 0?this.getPercentString(5.0F):super.getDescriptionParams(index, difficulty);
   }
}
