package ungp.impl.rules.member;

import com.fs.starfarer.api.fleet.FleetMemberAPI;
import ungp.api.rules.UNGP_MemberBuffRuleEffect;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings.Difficulty;

public class UNGP_WideRadar extends UNGP_MemberBuffRuleEffect {

   private float bonus;


   public void updateDifficultyCache(Difficulty difficulty) {
      this.bonus = this.getValueByDifficulty(0, difficulty);
   }

   public float getValueByDifficulty(int index, Difficulty difficulty) {
      return index == 0?difficulty.getLinearValue(0.25F, 0.25F):0.0F;
   }

   public void applyPlayerFleetMemberInCampaign(FleetMemberAPI member) {
      member.getStats().getSensorStrength().modifyMult(this.buffID, 1.0F + this.bonus);
   }

   public String getDescriptionParams(int index, Difficulty difficulty) {
      return index == 0?this.getPercentString(this.getValueByDifficulty(index, difficulty) * 100.0F):null;
   }
}
