package ungp.impl.rules.member;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipHullSpecAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.util.ArrayList;
import java.util.Iterator;
import ungp.api.rules.UNGP_MemberBuffRuleEffect;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings.Difficulty;

public class UNGP_TtsInvicible extends UNGP_MemberBuffRuleEffect {

   private static final float NORMAL_BONUS = 50.0F;
   private static final float DAMAGE_BONUS = 15.0F;
   private static final float CR_BONUS = 10.0F;


   public float getValueByDifficulty(int index, Difficulty difficulty) {
      return 0.0F;
   }

   public String getDescriptionParams(int index, Difficulty difficulty) {
      return index == 0?this.getPercentString(50.0F):(index == 1?this.getPercentString(15.0F):(index == 2?this.getPercentString(10.0F):super.getDescriptionParams(index, difficulty)));
   }

   public void applyPlayerFleetMemberInCampaign(FleetMemberAPI member) {
      MutableShipStatsAPI stats = member.getStats();
      String id = this.buffID;
      stats.getShieldUpkeepMult().modifyMult(id, 0.5F);
      stats.getShieldUnfoldRateMult().modifyPercent(id, 50.0F);
      stats.getShieldTurnRateMult().modifyPercent(id, 50.0F);
      stats.getEnergyWeaponDamageMult().modifyPercent(id, 15.0F);
      stats.getBallisticWeaponDamageMult().modifyPercent(id, 15.0F);
      stats.getMissileWeaponDamageMult().modifyPercent(id, 15.0F);
      stats.getEnergyRoFMult().modifyPercent(id, 15.0F);
      stats.getBallisticRoFMult().modifyPercent(id, 15.0F);
      stats.getMissileRoFMult().modifyPercent(id, 15.0F);
      stats.getMaxCombatReadiness().modifyFlat(id, 0.099999994F, this.rule.getName());
   }

   public boolean addIntelTips(TooltipMakerAPI imageTooltip) {
      imageTooltip.addPara(this.rule.getExtra1(), 0.0F);
      ArrayList names = new ArrayList();
      Iterator var3 = Global.getSettings().getAllShipHullSpecs().iterator();

      while(var3.hasNext()) {
         ShipHullSpecAPI hullSpec = (ShipHullSpecAPI)var3.next();
         if(isParagon(hullSpec) && !hullSpec.isDefaultDHull()) {
            names.add(hullSpec.getNameWithDesignationWithDashClass());
         }
      }

      imageTooltip.addPara(Misc.getAndJoined(names), Misc.getHighlightColor(), 5.0F);
      return true;
   }

   public boolean canApply(FleetMemberAPI member) {
      return member.isFlagship() && isParagon(member.getHullSpec());
   }

   public static boolean isParagon(ShipHullSpecAPI hullSpec) {
      return hullSpec.getHullId().contains("paragon") || hullSpec.getTags().contains("ungp_paragon");
   }
}
