package ungp.impl.rules.member;

import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import ungp.api.rules.UNGP_MemberBuffRuleEffect;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings.Difficulty;

public class UNGP_ShieldSpecialization extends UNGP_MemberBuffRuleEffect {

   private float commonBonus;
   private float upkeepBonus;


   public void updateDifficultyCache(Difficulty difficulty) {
      this.commonBonus = this.getValueByDifficulty(0, difficulty);
      this.upkeepBonus = this.getValueByDifficulty(1, difficulty);
   }

   public float getValueByDifficulty(int index, Difficulty difficulty) {
      return index == 0?difficulty.getLinearValue(5.0F, 5.0F):(index == 1?difficulty.getLinearValue(10.0F, 10.0F):0.0F);
   }

   public String getDescriptionParams(int index, Difficulty difficulty) {
      return index != 0 && index != 1?super.getDescriptionParams(index, difficulty):this.getPercentString(this.getValueByDifficulty(index, difficulty));
   }

   public void applyPlayerFleetMemberInCampaign(FleetMemberAPI member) {
      MutableShipStatsAPI stats = member.getStats();
      String id = this.getBuffID();
      stats.getShieldDamageTakenMult().modifyMult(id, 1.0F - this.commonBonus * 0.01F);
      stats.getShieldTurnRateMult().modifyPercent(id, this.commonBonus);
      stats.getShieldUnfoldRateMult().modifyPercent(id, this.commonBonus);
      stats.getShieldUpkeepMult().modifyMult(id, 1.0F - this.upkeepBonus * 0.01F);
   }
}
