package ungp.impl.rules.member;

import com.fs.starfarer.api.fleet.FleetMemberAPI;
import ungp.api.rules.UNGP_MemberBuffRuleEffect;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings.Difficulty;

public class UNGP_MoreLogistics extends UNGP_MemberBuffRuleEffect {

   private float bonus;


   public void updateDifficultyCache(Difficulty difficulty) {
      this.bonus = this.getValueByDifficulty(0, difficulty);
   }

   public float getValueByDifficulty(int index, Difficulty difficulty) {
      return index == 0?(difficulty == Difficulty.OMEGA?2.0F:1.0F):0.0F;
   }

   public void applyPlayerFleetMemberInCampaign(FleetMemberAPI member) {
      member.getStats().getDynamic().getMod("max_logistics_hullmods_mod").modifyFlat(this.buffID, this.bonus);
   }

   public String getDescriptionParams(int index, Difficulty difficulty) {
      return index == 0?this.getFactorString(this.getValueByDifficulty(index, difficulty)):null;
   }
}
