package ungp.impl.rules.member;

import com.fs.starfarer.api.fleet.FleetMemberAPI;
import ungp.api.rules.UNGP_MemberBuffRuleEffect;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings.Difficulty;

public class UNGP_LowRepairTech extends UNGP_MemberBuffRuleEffect {

   private float reduction;


   public void updateDifficultyCache(Difficulty difficulty) {
      this.reduction = this.getValueByDifficulty(0, difficulty);
   }

   public float getValueByDifficulty(int index, Difficulty difficulty) {
      return index == 0?difficulty.getLinearValue(0.15F, 0.1F):0.0F;
   }

   public void applyPlayerFleetMemberInCampaign(FleetMemberAPI member) {
      member.getStats().getBaseCRRecoveryRatePercentPerDay().modifyPercent(this.buffID, -this.reduction * 100.0F);
      member.getStats().getRepairRatePercentPerDay().modifyPercent(this.buffID, -this.reduction * 100.0F);
   }

   public String getDescriptionParams(int index, Difficulty difficulty) {
      return index == 0?this.getPercentString(this.getValueByDifficulty(index, difficulty) * 100.0F):super.getDescriptionParams(index, difficulty);
   }
}
