package ungp.impl.rules.member;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipHullSpecAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.util.ArrayList;
import java.util.Iterator;
import ungp.api.rules.UNGP_MemberBuffRuleEffect;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings.Difficulty;

public class UNGP_HssPhoenix extends UNGP_MemberBuffRuleEffect {

   private static final float NORMAL_BONUS = 20.0F;
   private static final float MANEUVER_BONUS = 100.0F;
   private static final float CR_BONUS = 10.0F;


   public float getValueByDifficulty(int index, Difficulty difficulty) {
      return 0.0F;
   }

   public String getDescriptionParams(int index, Difficulty difficulty) {
      return index == 0?this.getPercentString(20.0F):(index == 1?this.getPercentString(100.0F):(index == 2?this.getPercentString(10.0F):super.getDescriptionParams(index, difficulty)));
   }

   public void applyPlayerFleetMemberInCampaign(FleetMemberAPI member) {
      MutableShipStatsAPI stats = member.getStats();
      String id = this.buffID;
      stats.getHullBonus().modifyPercent(id, 20.0F);
      stats.getArmorBonus().modifyPercent(id, 20.0F);
      stats.getFluxCapacity().modifyPercent(id, 20.0F);
      stats.getFluxDissipation().modifyPercent(id, 20.0F);
      stats.getMaxSpeed().modifyPercent(id, 100.0F);
      stats.getAcceleration().modifyPercent(id, 100.0F);
      stats.getDeceleration().modifyPercent(id, 100.0F);
      stats.getMaxTurnRate().modifyPercent(id, 100.0F);
      stats.getTurnAcceleration().modifyPercent(id, 100.0F);
      stats.getMaxCombatReadiness().modifyFlat(id, 0.099999994F, this.rule.getName());
   }

   public boolean addIntelTips(TooltipMakerAPI imageTooltip) {
      imageTooltip.addPara(this.rule.getExtra1(), 0.0F);
      ArrayList names = new ArrayList();
      Iterator var3 = Global.getSettings().getAllShipHullSpecs().iterator();

      while(var3.hasNext()) {
         ShipHullSpecAPI hullSpec = (ShipHullSpecAPI)var3.next();
         if(isOnslaught(hullSpec) && !hullSpec.isDefaultDHull()) {
            names.add(hullSpec.getNameWithDesignationWithDashClass());
         }
      }

      imageTooltip.addPara(Misc.getAndJoined(names), Misc.getHighlightColor(), 5.0F);
      return true;
   }

   public boolean canApply(FleetMemberAPI member) {
      return member.isFlagship() && isOnslaught(member.getHullSpec());
   }

   public static boolean isOnslaught(ShipHullSpecAPI hullSpec) {
      return hullSpec.getHullId().contains("onslaught") || hullSpec.getTags().contains("ungp_onslaught");
   }
}
