package ungp.impl.rules.member;

import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import ungp.api.rules.UNGP_MemberBuffRuleEffect;
import ungp.api.rules.tags.UNGP_PlayerFleetTag;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings.Difficulty;

public class UNGP_EliteReserves extends UNGP_MemberBuffRuleEffect implements UNGP_PlayerFleetTag {

   private float maxBonus;
   private float curBonus;


   public void updateDifficultyCache(Difficulty difficulty) {
      this.maxBonus = this.getValueByDifficulty(0, difficulty);
      this.curBonus = 0.0F;
   }

   public float getValueByDifficulty(int index, Difficulty difficulty) {
      return index == 0?0.15F:0.0F;
   }

   public void applyPlayerFleetStats(CampaignFleetAPI fleet) {
      float crew = (float)fleet.getCargo().getCrew();
      float minCrew = fleet.getFleetData().getMinCrew();
      float level = (crew - minCrew) / minCrew;
      level = Math.min(1.0F, Math.max(0.0F, level));
      this.curBonus = level * this.maxBonus;
   }

   public void unapplyPlayerFleetStats(CampaignFleetAPI fleet) {
   }

   public void applyPlayerFleetMemberInCampaign(FleetMemberAPI member) {
      member.getStats().getMaxCombatReadiness().modifyFlat(this.buffID, this.curBonus, this.rule.getName());
   }

   public String getDescriptionParams(int index, Difficulty difficulty) {
      return index == 0?this.getPercentString(this.getValueByDifficulty(index, difficulty) * 100.0F):null;
   }
}
