package ungp.impl.rules.member;

import com.fs.starfarer.api.campaign.FleetDataAPI;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI.HullSize;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import ungp.api.rules.UNGP_BaseRuleEffect;
import ungp.api.rules.tags.UNGP_CombatInitTag;
import ungp.api.rules.tags.UNGP_PlayerShipSkillTag;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings.Difficulty;

public class UNGP_CruisingHunting extends UNGP_BaseRuleEffect implements UNGP_CombatInitTag, UNGP_PlayerShipSkillTag {

   private static final int DP_REDUCTION_FLAT = 2;
   private float dpReductionFactor;


   public void updateDifficultyCache(Difficulty difficulty) {
      this.dpReductionFactor = this.getValueByDifficulty(0, difficulty);
   }

   public float getValueByDifficulty(int index, Difficulty difficulty) {
      return index == 0?difficulty.getLinearValue(0.08F, 0.04F):super.getValueByDifficulty(index, difficulty);
   }

   public String getDescriptionParams(int index, Difficulty difficulty) {
      return index == 0?this.getPercentString(this.getValueByDifficulty(index, difficulty) * 100.0F):(index == 1?"2":super.getDescriptionParams(index, difficulty));
   }

   public void init(CombatEngineAPI engine) {
   }

   public void apply(FleetDataAPI fleetData, FleetMemberAPI member, MutableShipStatsAPI stats, HullSize hullSize) {
      if(hullSize == HullSize.CRUISER) {
         float dp = stats.getSuppliesToRecover().getBaseValue();
         int reduction = (int)Math.ceil((double)Math.max(2.0F, dp * this.dpReductionFactor));
         stats.getDynamic().getMod("deployment_points_mod").modifyFlat(this.buffID, (float)(-reduction));
      }

   }

   public void unapply(MutableShipStatsAPI stats, HullSize hullSize) {
      stats.getDynamic().getMod("deployment_points_mod").unmodify(this.buffID);
   }
}
