package ungp.impl.rules.economy;

import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.util.Misc;
import java.util.Iterator;
import java.util.List;
import ungp.api.rules.UNGP_BaseRuleEffect;
import ungp.api.rules.tags.UNGP_EconomyTag;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings.Difficulty;

public class UNGP_TradeEmbargo extends UNGP_BaseRuleEffect implements UNGP_EconomyTag {

   public float getValueByDifficulty(int index, Difficulty difficulty) {
      return 0.0F;
   }

   public String getDescriptionParams(int index, Difficulty difficulty) {
      return index == 0?"15":(index == 1?"10%":super.getDescriptionParams(index, difficulty));
   }

   public void applyPlayerMarket(MarketAPI market) {
      List nearbyMarkets = Misc.getNearbyMarkets(market.getLocationInHyperspace(), 15.0F);
      int hostileCount = 0;
      Iterator var4 = nearbyMarkets.iterator();

      while(var4.hasNext()) {
         MarketAPI nearbyMarket = (MarketAPI)var4.next();
         if(nearbyMarket.getFaction().isHostileTo(market.getFaction())) {
            ++hostileCount;
         }
      }

      market.getAccessibilityMod().modifyFlat(this.buffID, (float)(-hostileCount) * 0.1F, this.rule.getName());
   }

   public void unapplyPlayerMarket(MarketAPI market) {
      market.getAccessibilityMod().unmodify(this.buffID);
   }

   public void applyAllMarket(MarketAPI market) {
   }

   public void unapplyAllMarket(MarketAPI market) {
   }
}
