package ungp.impl.rules.economy;

import com.fs.starfarer.api.campaign.econ.MarketAPI;
import ungp.api.rules.UNGP_BaseRuleEffect;
import ungp.api.rules.tags.UNGP_EconomyTag;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings.Difficulty;

public class UNGP_Mercantilism extends UNGP_BaseRuleEffect implements UNGP_EconomyTag {

   private static final float ACCESS_THRESHOLD = 1.5F;
   private float bonus;


   public void updateDifficultyCache(Difficulty difficulty) {
      this.bonus = this.getValueByDifficulty(0, difficulty);
   }

   public float getValueByDifficulty(int index, Difficulty difficulty) {
      return index == 0?difficulty.getLinearValue(0.2F, 0.1F):0.0F;
   }

   public void applyPlayerMarket(MarketAPI market) {
      float couldBonus = this.bonus;
      if(market.getAccessibilityMod().computeEffective(0.0F) > 1.5F) {
         couldBonus *= 0.5F;
      }

      market.getAccessibilityMod().modifyFlat(this.buffID, couldBonus, this.rule.getName());
   }

   public void unapplyPlayerMarket(MarketAPI market) {
      market.getAccessibilityMod().unmodify(this.buffID);
   }

   public void applyAllMarket(MarketAPI market) {
   }

   public void unapplyAllMarket(MarketAPI market) {
   }

   public String getDescriptionParams(int index, Difficulty difficulty) {
      return index == 0?this.getPercentString(this.getValueByDifficulty(index, difficulty) * 100.0F):(index == 1?this.getPercentString(150.0F):(index == 2?i18n.get("halved"):null));
   }
}
