package ungp.impl.rules.economy;

import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.MutableCommodityQuantity;
import com.fs.starfarer.api.util.Misc;
import java.util.Iterator;
import ungp.api.rules.UNGP_BaseRuleEffect;
import ungp.api.rules.tags.UNGP_EconomyTag;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings.Difficulty;

public class UNGP_IndustrialZone extends UNGP_BaseRuleEffect implements UNGP_EconomyTag {

   private static final int SIZE_THRESHOLD = 5;


   public void updateDifficultyCache(Difficulty difficulty) {
   }

   public float getValueByDifficulty(int index, Difficulty difficulty) {
      return index == 0?1.0F:0.0F;
   }

   public void applyPlayerMarket(MarketAPI market) {
      market.getStats().getDynamic().getMod("max_industries").unmodify(this.buffID);
      int curIndustries = Misc.getNumIndustries(market);
      int maxIndustries = Misc.getMaxIndustries(market);
      int size = market.getSize();
      if(size <= 5 && curIndustries > maxIndustries) {
         Iterator var5 = market.getIndustries().iterator();

         while(var5.hasNext()) {
            Industry industry = (Industry)var5.next();
            if(industry.isIndustry()) {
               Iterator var7 = industry.getAllSupply().iterator();

               while(var7.hasNext()) {
                  MutableCommodityQuantity commodityQuantity = (MutableCommodityQuantity)var7.next();
                  commodityQuantity.getQuantity().modifyFlat(this.buffID, -1.0F, this.rule.getName());
               }
            }
         }
      } else {
         this.unapplyPlayerMarket(market);
      }

      market.getStats().getDynamic().getMod("max_industries").modifyFlat(this.buffID, 1.0F);
   }

   public void unapplyPlayerMarket(MarketAPI market) {
      market.getStats().getDynamic().getMod("max_industries").unmodify(this.buffID);
      Iterator var2 = market.getIndustries().iterator();

      while(var2.hasNext()) {
         Industry industry = (Industry)var2.next();
         if(industry.isIndustry()) {
            Iterator var4 = industry.getAllSupply().iterator();

            while(var4.hasNext()) {
               MutableCommodityQuantity commodityQuantity = (MutableCommodityQuantity)var4.next();
               commodityQuantity.getQuantity().unmodify(this.buffID);
            }
         }
      }

   }

   public void applyAllMarket(MarketAPI market) {
   }

   public void unapplyAllMarket(MarketAPI market) {
   }

   public String getDescriptionParams(int index, Difficulty difficulty) {
      return index == 0?this.getFactorString(1.0F):(index == 1?this.getFactorString(5.0F):(index == 2?this.getFactorString(1.0F):null));
   }
}
