package ungp.impl.rules.economy;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.MutableCommodityQuantity;
import com.fs.starfarer.api.impl.campaign.intel.MessageIntel;
import com.fs.starfarer.api.util.Misc;
import java.util.Iterator;
import ungp.api.rules.UNGP_BaseRuleEffect;
import ungp.api.rules.tags.UNGP_EconomyTag;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings.Difficulty;

public class UNGP_GLaDos extends UNGP_BaseRuleEffect implements UNGP_EconomyTag {

   public void updateDifficultyCache(Difficulty difficulty) {
      Boolean sent = (Boolean)this.getDataInCampaign(0);
      if(sent == null) {
         Global.getSector().addTransientScript(new EveryFrameScript() {

            float duration;
            boolean done;

            {
               this.duration = 2.0F + UNGP_GLaDos.RANDOM.nextFloat();
               this.done = false;
            }
            public boolean isDone() {
               return this.done;
            }
            public boolean runWhilePaused() {
               return false;
            }
            public void advance(float amount) {
               this.duration -= amount;
               if(this.duration <= 0.0F) {
                  MessageIntel message = UNGP_GLaDos.this.createMessage();
                  message.addLine(UNGP_GLaDos.this.rule.getExtra1(), Misc.getBasePlayerColor());
                  message.setSound("UNGP_glados_chosen");
                  UNGP_GLaDos.this.showMessage(message);
                  this.done = true;
                  Global.getSector().removeTransientScript(this);
               }

            }
         });
         this.saveDataInCampaign(0, Boolean.valueOf(true));
      }

   }

   public float getValueByDifficulty(int index, Difficulty difficulty) {
      return index == 0?1.0F:super.getValueByDifficulty(index, difficulty);
   }

   public void applyPlayerMarket(MarketAPI market) {
      Iterator var2 = market.getIndustries().iterator();

      while(var2.hasNext()) {
         Industry industry = (Industry)var2.next();
         Iterator var4;
         MutableCommodityQuantity mutableCommodityQuantity;
         if(industry.getAICoreId() != null && industry.getAICoreId().contentEquals("alpha_core")) {
            var4 = industry.getAllSupply().iterator();

            while(var4.hasNext()) {
               mutableCommodityQuantity = (MutableCommodityQuantity)var4.next();
               mutableCommodityQuantity.getQuantity().modifyFlat(this.buffID, 1.0F, this.rule.getName());
            }
         } else {
            var4 = industry.getAllSupply().iterator();

            while(var4.hasNext()) {
               mutableCommodityQuantity = (MutableCommodityQuantity)var4.next();
               mutableCommodityQuantity.getQuantity().unmodify(this.buffID);
            }
         }
      }

   }

   public void unapplyPlayerMarket(MarketAPI market) {
      Iterator var2 = market.getIndustries().iterator();

      while(var2.hasNext()) {
         Industry industry = (Industry)var2.next();
         Iterator var4 = industry.getAllSupply().iterator();

         while(var4.hasNext()) {
            MutableCommodityQuantity mutableCommodityQuantity = (MutableCommodityQuantity)var4.next();
            mutableCommodityQuantity.getQuantity().unmodify(this.buffID);
         }
      }

   }

   public void applyAllMarket(MarketAPI market) {
   }

   public void unapplyAllMarket(MarketAPI market) {
   }

   public String getDescriptionParams(int index, Difficulty difficulty) {
      return index == 0?this.getFactorString(1.0F):null;
   }
}
