package ungp.impl.rules.economy;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.PlayerMarketTransaction;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.listeners.ColonyInteractionListener;
import com.fs.starfarer.api.impl.campaign.intel.MessageIntel;
import com.fs.starfarer.api.impl.campaign.submarkets.BlackMarketPlugin;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import ungp.api.rules.UNGP_BaseRuleEffect;
import ungp.api.rules.tags.UNGP_CampaignListenerTag;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings.Difficulty;

public class UNGP_Fraudulent extends UNGP_BaseRuleEffect implements UNGP_CampaignListenerTag {

   private static final float DROP_FACTOR = 0.2F;
   private float chance;


   public void updateDifficultyCache(Difficulty difficulty) {
      this.chance = this.getValueByDifficulty(0, difficulty);
   }

   public float getValueByDifficulty(int index, Difficulty difficulty) {
      return index == 0?difficulty.getLinearValue(0.15F, 0.15F):0.0F;
   }

   public String getDescriptionParams(int index, Difficulty difficulty) {
      return index == 0?this.getPercentString(this.getValueByDifficulty(index, difficulty) * 100.0F):(index == 1?this.getPercentString(20.0F):super.getDescriptionParams(index, difficulty));
   }

   public UNGP_Fraudulent.MarketTransactionListener getListener() {
      return new UNGP_Fraudulent.MarketTransactionListener();
   }

   public Class getClassOfListener() {
      return UNGP_Fraudulent.MarketTransactionListener.class;
   }

   public class MarketTransactionListener implements ColonyInteractionListener {

      public void reportPlayerOpenedMarket(MarketAPI market) {
      }

      public void reportPlayerClosedMarket(MarketAPI market) {
      }

      public void reportPlayerOpenedMarketAndCargoUpdated(MarketAPI market) {
      }

      public void reportPlayerMarketTransaction(PlayerMarketTransaction transaction) {
         float rollChance = UNGP_Fraudulent.this.chance;
         if(transaction.getSubmarket() != null && transaction.getSubmarket().getPlugin() instanceof BlackMarketPlugin) {
            rollChance *= 2.0F;
         }

         if(UNGP_Fraudulent.this.roll(rollChance)) {
            float creditValue = transaction.getCreditValue();
            if(creditValue > 0.0F) {
               int dropCredit = (int)(creditValue * 0.2F);
               MessageIntel message = UNGP_Fraudulent.this.createMessage();
               message.addLine(UNGP_Fraudulent.this.rule.getExtra1(), Misc.getTextColor(), new String[]{Misc.getDGSCredits((float)dropCredit)}, new Color[]{Misc.getHighlightColor()});
               message.setSound("UNGP_fraudulent_activate");
               UNGP_Fraudulent.this.showMessage(message);
               Global.getSector().getPlayerFleet().getCargo().getCredits().subtract((float)dropCredit);
            }
         }

      }
   }
}
