package ungp.impl.rules.economy;

import com.fs.starfarer.api.campaign.SubmarketPlugin;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.SubmarketAPI;
import com.fs.starfarer.api.impl.campaign.shared.PlayerTradeDataForSubmarket;
import com.fs.starfarer.api.impl.campaign.shared.SharedData;
import java.util.Iterator;
import ungp.api.rules.UNGP_BaseRuleEffect;
import ungp.api.rules.tags.UNGP_EconomyTag;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings.Difficulty;

public class UNGP_BlackInBlack extends UNGP_BaseRuleEffect implements UNGP_EconomyTag {

   public void updateDifficultyCache(Difficulty difficulty) {
   }

   public float getValueByDifficulty(int index, Difficulty difficulty) {
      return 0.0F;
   }

   public String getDescriptionParams(int index, Difficulty difficulty) {
      return null;
   }

   public void applyPlayerMarket(MarketAPI market) {
   }

   public void unapplyPlayerMarket(MarketAPI market) {
   }

   public void applyAllMarket(MarketAPI market) {
      Iterator var2 = market.getSubmarketsCopy().iterator();

      while(var2.hasNext()) {
         SubmarketAPI subMarket = (SubmarketAPI)var2.next();
         SubmarketPlugin plugin = subMarket.getPlugin();
         if(plugin.isParticipatesInEconomy()) {
            PlayerTradeDataForSubmarket tradeData = SharedData.getData().getPlayerActivityTracker().getPlayerTradeData(subMarket);
            if(subMarket.getFaction().isHostileTo(market.getFaction()) || subMarket.getPlugin().isBlackMarket()) {
               tradeData.setTotalPlayerTradeValue(0.0F);
            }
         }
      }

      market.getMemoryWithoutUpdate().set("$marketExtraSuspicion", Float.valueOf(0.0F));
   }

   public void unapplyAllMarket(MarketAPI market) {
   }
}
