package ungp.impl.rules.character;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import ungp.api.rules.UNGP_BaseRuleEffect;
import ungp.api.rules.tags.UNGP_PlayerCharacterStatsSkillTag;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings.Difficulty;

public class UNGP_TechRevolution extends UNGP_BaseRuleEffect implements UNGP_PlayerCharacterStatsSkillTag {

   public static final float MAXIMUM_CYCLE = 4.0F;
   private float bonus;


   public void updateDifficultyCache(Difficulty difficulty) {
      this.bonus = this.getValueByDifficulty(0, difficulty);
   }

   public float getValueByDifficulty(int index, Difficulty difficulty) {
      return index == 0?difficulty.getLinearValue(0.08F, 0.02F):super.getValueByDifficulty(index, difficulty);
   }

   public void apply(MutableCharacterStatsAPI stats) {
      stats.getShipOrdnancePointBonus().modifyPercent(this.buffID, this.bonus * 100.0F * this.getBonusFactor());
   }

   private float getBonusFactor() {
      Long latestTimestamp = (Long)this.getDataInCampaign(0);
      if(latestTimestamp == null) {
         latestTimestamp = Long.valueOf(Global.getSector().getClock().getTimestamp());
         this.saveDataInCampaign(0, latestTimestamp);
      }

      long exTime = Math.max(0L, Global.getSector().getClock().getTimestamp() - latestTimestamp.longValue());
      float cycleFactor = 0.0F;
      if(exTime > 0L) {
         cycleFactor = (float)exTime / 1000.0F / 60.0F / 60.0F / 24.0F / 365.0F;
         cycleFactor *= 0.25F;
      }

      return Math.min(1.0F, 0.25F + 0.75F * cycleFactor);
   }

   public void unapply(MutableCharacterStatsAPI stats) {
      stats.getShipOrdnancePointBonus().unmodify(this.buffID);
   }

   public boolean addIntelTips(TooltipMakerAPI imageTooltip) {
      imageTooltip.addPara(this.rule.getExtra1(), 0.0F);
      imageTooltip.addPara((int)(this.getBonusFactor() * 100.0F), Misc.getHighlightColor(), 0.0F);
      return super.addIntelTips(imageTooltip);
   }

   public String getDescriptionParams(int index, Difficulty difficulty) {
      return index == 0?this.getPercentString(this.getValueByDifficulty(index, difficulty) * 100.0F):(index == 1?this.getPercentString(25.0F):(index == 2?"4":super.getDescriptionParams(index, difficulty)));
   }
}
