package ungp.impl.rules.character;

import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import ungp.api.rules.UNGP_BaseRuleEffect;
import ungp.api.rules.tags.UNGP_PlayerCharacterStatsSkillTag;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings.Difficulty;

public class UNGP_TechLock extends UNGP_BaseRuleEffect implements UNGP_PlayerCharacterStatsSkillTag {

   private float reduction;


   public void updateDifficultyCache(Difficulty difficulty) {
      this.reduction = this.getValueByDifficulty(0, difficulty);
   }

   public void apply(MutableCharacterStatsAPI stats) {
      stats.getShipOrdnancePointBonus().modifyPercent(this.buffID, -this.reduction * 100.0F);
   }

   public void unapply(MutableCharacterStatsAPI stats) {
      stats.getShipOrdnancePointBonus().unmodify(this.buffID);
   }

   public float getValueByDifficulty(int index, Difficulty difficulty) {
      return index == 0?difficulty.getLinearValue(0.05F, 0.05F):super.getValueByDifficulty(index, difficulty);
   }

   public String getDescriptionParams(int index, Difficulty difficulty) {
      return index == 0?this.getPercentString(this.getValueByDifficulty(index, difficulty) * 100.0F):super.getDescriptionParams(index, difficulty);
   }
}
