package ungp.impl.rules.character;

import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import ungp.api.rules.UNGP_BaseRuleEffect;
import ungp.api.rules.tags.UNGP_PlayerCharacterStatsSkillTag;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings.Difficulty;

public class UNGP_GalatiaUnderachiever extends UNGP_BaseRuleEffect implements UNGP_PlayerCharacterStatsSkillTag {

   private int commandPointsReduction;
   private float commandRateReduction;


   public void updateDifficultyCache(Difficulty difficulty) {
      this.commandPointsReduction = (int)this.getValueByDifficulty(0, difficulty);
      this.commandRateReduction = this.getValueByDifficulty(1, difficulty);
   }

   public float getValueByDifficulty(int index, Difficulty difficulty) {
      return index == 0?difficulty.getLinearValue(1.0F, 1.0F):(index == 1?difficulty.getLinearValue(0.25F, 0.25F):super.getValueByDifficulty(index, difficulty));
   }

   public String getDescriptionParams(int param1, Difficulty param2) {
      // $FF: Couldn't be decompiled
   }

   public void apply(MutableCharacterStatsAPI stats) {
      stats.getCommandPoints().modifyFlat(this.buffID, (float)(-this.commandPointsReduction));
      stats.getDynamic().getStat("command_point_rate").modifyFlat(this.buffID, -this.commandRateReduction);
   }

   public void unapply(MutableCharacterStatsAPI stats) {
      stats.getCommandPoints().unmodify(this.buffID);
      stats.getDynamic().getStat("command_point_rate").unmodify(this.buffID);
   }
}
