package ungp.impl.rules.character;

import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import ungp.api.rules.UNGP_BaseRuleEffect;
import ungp.api.rules.tags.UNGP_PlayerCharacterStatsSkillTag;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings.Difficulty;

public class UNGP_EwSmog extends UNGP_BaseRuleEffect implements UNGP_PlayerCharacterStatsSkillTag {

   private float ewBonus;


   public void updateDifficultyCache(Difficulty difficulty) {
      this.ewBonus = this.getValueByDifficulty(0, difficulty);
   }

   public float getValueByDifficulty(int index, Difficulty difficulty) {
      return index == 0?difficulty.getLinearValue(5.0F, 5.0F):super.getValueByDifficulty(index, difficulty);
   }

   public void apply(MutableCharacterStatsAPI stats) {
      stats.getDynamic().getMod("electronic_warfare_max").modifyFlat(this.buffID, this.ewBonus);
   }

   public void unapply(MutableCharacterStatsAPI stats) {
      stats.getDynamic().getMod("electronic_warfare_max").unmodifyFlat(this.buffID);
   }

   public String getDescriptionParams(int index, Difficulty difficulty) {
      return index == 0?this.getPercentString(this.getValueByDifficulty(index, difficulty)):super.getDescriptionParams(index, difficulty);
   }
}
