package ungp.impl.rules.character;

import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import ungp.api.rules.UNGP_BaseRuleEffect;
import ungp.api.rules.tags.UNGP_PlayerCharacterStatsSkillTag;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings.Difficulty;

public class UNGP_Besieged extends UNGP_BaseRuleEffect implements UNGP_PlayerCharacterStatsSkillTag {

   private float dp;


   public void updateDifficultyCache(Difficulty difficulty) {
      this.dp = this.getValueByDifficulty(0, difficulty);
   }

   public float getValueByDifficulty(int index, Difficulty difficulty) {
      return index == 0?difficulty.getLinearValue(0.04F, 0.04F):super.getValueByDifficulty(index, difficulty);
   }

   public String getDescriptionParams(int index, Difficulty difficulty) {
      return index == 0?this.getPercentString(this.getValueByDifficulty(index, difficulty) * 100.0F):super.getDescriptionParams(index, difficulty);
   }

   public void apply(MutableCharacterStatsAPI stats) {
      stats.getDynamic().getMod("deployment_points_fraction_of_battle_size_bonus_mod").modifyFlat(this.buffID, -this.dp);
      stats.getDynamic().getMod("deployment_points_min_fraction_of_battle_size_bonus_mod").modifyFlat(this.buffID, -this.dp);
   }

   public void unapply(MutableCharacterStatsAPI stats) {
      stats.getDynamic().getMod("deployment_points_fraction_of_battle_size_bonus_mod").unmodifyFlat(this.buffID);
      stats.getDynamic().getMod("deployment_points_min_fraction_of_battle_size_bonus_mod").unmodifyFlat(this.buffID);
   }
}
